/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.CommonCertificateProvider;
import de.intarsys.security.certificate.common.CommonX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.CertificateFilterIterator;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.privatekey.IPasswordProtectionSupport;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.EnumerationIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.NullFilterIterator;
import de.intarsys.tools.crypto.Secret;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreCertificateProvider
extends CommonCertificateProvider
implements IPrivateKeyProvider,
IPasswordProtectionSupport,
IAttributeSupport {
    private static final Logger Log = LoggerFactory.getLogger(KeyStoreCertificateProvider.class);
    private final KeyStore keyStore;
    private final Map<String, IX509PublicKeyCertificate> aliasToCertificate = new HashMap<String, IX509PublicKeyCertificate>();
    private String label;
    private AttributeMap attributes = new AttributeMap();

    public KeyStoreCertificateProvider(KeyStore keyStore) {
        this.keyStore = keyStore;
    }

    protected boolean accept(IX509CertificateFilter filter) {
        return true;
    }

    protected boolean accept(String alias, IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null) {
                try {
                    if (selector.hasPrivateKey().booleanValue() != this.getKeyStore().isKeyEntry(alias)) {
                        return false;
                    }
                }
                catch (GeneralSecurityException e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            if (!(selector.getAlias() == null || alias != null && alias.equals(selector.getAlias()))) {
                return false;
            }
        }
        return true;
    }

    public Iterator<String> aliases(final IX509CertificateFilter filter) {
        if (!this.accept(filter)) {
            return Collections.emptyIterator();
        }
        Object aliases = null;
        try {
            aliases = new EnumerationIterator(this.getKeyStore().aliases());
        }
        catch (KeyStoreException e) {
            aliases = Collections.emptyIterator();
            Log.warn(e.getMessage(), (Throwable)e);
        }
        aliases = new FilterIterator<String>((Iterator)aliases){

            protected boolean accept(String alias) {
                return KeyStoreCertificateProvider.this.accept(alias, filter);
            }
        };
        return aliases;
    }

    public boolean containsAlias(String alias) {
        try {
            return this.getKeyStore().containsAlias(alias);
        }
        catch (KeyStoreException e) {
            Log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public String getAlias(IX509PublicKeyCertificate certificate) {
        return certificate.getAlias();
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public IX509Certificate getCertificate(String alias) throws KeyStoreException {
        X509Certificate certificateImpl;
        IX509PublicKeyCertificate certificate = this.aliasToCertificate.get(alias);
        if (certificate == null && (certificateImpl = (X509Certificate)this.getKeyStore().getCertificate(alias)) != null) {
            certificate = CertificateTools.wrapJavaCert(certificateImpl);
            ((CommonX509PublicKeyCertificate)certificate).setCertificateProvider(this);
            ((CommonX509PublicKeyCertificate)certificate).setAlias(alias);
            this.aliasToCertificate.put(alias, certificate);
        }
        return certificate;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            this.label = "Keystore";
        }
        return this.label;
    }

    @Override
    public PrivateKey getPrivateKey(IX509PublicKeyCertificate certificate, IPasswordProvider passwordProvider) throws UnrecoverableKeyException, IOException {
        String alias = certificate.getAlias();
        Secret password = passwordProvider.getPassword();
        try {
            return (PrivateKey)this.getKeyStore().getKey(alias, password.getChars());
        }
        catch (UnrecoverableKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            UnrecoverableKeyException ex = new UnrecoverableKeyException(e.getMessage());
            ex.initCause(e);
            throw ex;
        }
    }

    @Override
    public String getProviderName() {
        return "BC";
    }

    @Override
    public boolean hasPrivateKey(IX509PublicKeyCertificate certificate) {
        if (certificate instanceof IAttributeSupport) {
            String alias = certificate.getAlias();
            try {
                if (this.getKeyStore().isKeyEntry(alias)) {
                    return true;
                }
            }
            catch (KeyStoreException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean isPrivateKeyPasswordProtected(IX509PublicKeyCertificate certificate) {
        return true;
    }

    @Override
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        Iterator<String> aliases = this.aliases(filter);
        ConversionIterator<String, IX509Certificate> certificates = new ConversionIterator<String, IX509Certificate>(aliases){

            protected IX509Certificate createTargetObject(String alias) {
                try {
                    return KeyStoreCertificateProvider.this.getCertificate(alias);
                }
                catch (GeneralSecurityException e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
        };
        certificates = new NullFilterIterator((Iterator)certificates);
        return filter == null ? certificates : new CertificateFilterIterator(certificates, filter);
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

