/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider.keystore;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.certificate.common.CollectionCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.keystore.Credential;
import de.intarsys.security.certificate.provider.keystore.ICredential;
import de.intarsys.security.certificate.provider.keystore.IKeyStore;
import de.intarsys.security.certificate.provider.keystore.PACKAGE;
import de.intarsys.security.privatekey.IPrivateKeyProvider;
import de.intarsys.security.privatekey.NullPrivateKeyProvider;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.IvParameterSpec;

public abstract class CommonKeyStore
implements IKeyStore {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    protected static final String DEFAULT_KEYSTORE_PASSWORD_NAME = "keystore";
    protected static final String DEFAULT_KEYSTORE_PASSWORD_LABEL = Msg.getString("CommonKeyStore.DefaultKeystorePasswordLabel", new Object[0]);
    protected static final String DEFAULT_KEY_PASSWORD_NAME = "key";
    protected static final String DEFAULT_KEY_PASSWORD_LABEL = Msg.getString("CommonKeyStore.DefaultKeyPasswordLabel", new Object[0]);
    public static String[] TYPES_ATZ = new String[]{"atz"};
    public static String[] TYPES_CRY = new String[]{"cry"};
    private ILocator locator;
    private ICertificateProvider certificateProvider;
    private IPrivateKeyProvider keyProvider;
    private boolean loaded;

    public static IKeyStore createATZ(ILocator locator) {
        return new ATZKeyStore(locator);
    }

    public static IKeyStore createCRY(ILocator locator) {
        return new CRYKeyStore(locator);
    }

    protected static boolean hasType(String requestedType, String[] types) {
        if (requestedType == null) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            String type = types[i];
            if (!type.equalsIgnoreCase(requestedType)) continue;
            return true;
        }
        return false;
    }

    public static boolean isATZ(ILocator locator) {
        return CommonKeyStore.isATZ(LocatorTools.getExtension((ILocator)locator));
    }

    protected static boolean isATZ(String type) {
        return CommonKeyStore.hasType(type, TYPES_ATZ);
    }

    public static boolean isCRY(ILocator locator) {
        return CommonKeyStore.isCRY(LocatorTools.getExtension((ILocator)locator));
    }

    protected static boolean isCRY(String type) {
        return CommonKeyStore.hasType(type, TYPES_CRY);
    }

    protected CommonKeyStore(ILocator locator) {
        this.locator = locator;
    }

    protected abstract void basicLoad(Secret var1) throws IOException, KeyStoreException;

    @Override
    public void close() {
        this.certificateProvider = null;
        this.loaded = false;
    }

    protected abstract ICertificateProvider createCertificateProvider();

    protected abstract IPrivateKeyProvider createKeyProvider();

    @Override
    public ICertificateProvider getCertificateProvider() {
        if (this.certificateProvider == null) {
            this.certificateProvider = this.createCertificateProvider();
        }
        return this.certificateProvider;
    }

    @Override
    public ICredential getKeyCredential() {
        return null;
    }

    @Override
    public IPrivateKeyProvider getKeyProvider() {
        if (this.keyProvider == null) {
            this.keyProvider = this.createKeyProvider();
        }
        return this.keyProvider;
    }

    @Override
    public ICredential getKeyStoreCredential() {
        return null;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public void load() throws IOException, KeyStoreException {
        this.load(null);
    }

    @Override
    public void load(Secret keystorePassword) throws IOException, KeyStoreException {
        if (this.loaded) {
            return;
        }
        this.basicLoad(keystorePassword);
        this.loaded = true;
    }

    @Override
    public final boolean needsKeyPassword() {
        return this.getKeyCredential() != null && !this.getKeyCredential().isOptional();
    }

    @Override
    public final boolean needsKeyStorePassword() {
        return this.getKeyStoreCredential() != null && !this.getKeyStoreCredential().isOptional();
    }

    @Override
    public final boolean supportsKeyPassword() {
        return this.getKeyCredential() != null;
    }

    @Override
    public final boolean supportsKeyStorePassword() {
        return this.getKeyStoreCredential() != null;
    }

    @Override
    public boolean supportsMultipleEntries() {
        return false;
    }

    @Override
    public boolean verifyKeyStorePassword(Secret keystorePassword) {
        if (this.getKeyStoreCredential() == null) {
            return true;
        }
        try {
            this.basicLoad(keystorePassword);
            return true;
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private static class ATZKeyStore
    extends CommonKeyStore {
        private IX509AttributeCertificate certificate;

        public ATZKeyStore(ILocator locator) {
            super(locator);
        }

        @Override
        protected void basicLoad(Secret keystorePassword) throws IOException, KeyStoreException {
            try (InputStream is = this.getLocator().getInputStream();){
                this.certificate = X509CertificateFactory.get().createAttributeCertificate(is);
            }
            catch (CertificateException e) {
                throw new KeyStoreException(e);
            }
        }

        @Override
        protected ICertificateProvider createCertificateProvider() {
            CollectionCertificateProvider certificateProvider = new CollectionCertificateProvider(ListTools.with((Object[])new IX509AttributeCertificate[]{this.certificate}));
            return certificateProvider;
        }

        @Override
        protected IPrivateKeyProvider createKeyProvider() {
            return new NullPrivateKeyProvider();
        }
    }

    private static class CRYKeyStore
    extends CommonKeyStore {
        private static final byte[] IV = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        private IX509AttributeCertificate certificate;

        public CRYKeyStore(ILocator locator) {
            super(locator);
        }

        @Override
        protected void basicLoad(Secret keystorePassword) throws IOException, KeyStoreException {
            if (CryptoTools.isEmpty((Secret)keystorePassword)) {
                throw new KeyStoreException("password missing");
            }
            try {
                byte[] decrypted = this.decrypt(this.getLocator(), keystorePassword);
                this.certificate = X509CertificateFactory.get().createAttributeCertificate(decrypted);
            }
            catch (GeneralSecurityException e) {
                throw new KeyStoreException(e);
            }
            catch (Exception e) {
                throw new KeyStoreException(e);
            }
        }

        @Override
        protected ICertificateProvider createCertificateProvider() {
            CollectionCertificateProvider certificateProvider = new CollectionCertificateProvider(ListTools.with((Object[])new IX509AttributeCertificate[]{this.certificate}));
            return certificateProvider;
        }

        @Override
        protected IPrivateKeyProvider createKeyProvider() {
            return new NullPrivateKeyProvider();
        }

        protected byte[] decrypt(ILocator encrypted, Secret keystorePassword) throws GeneralSecurityException, IOException {
            String password = CryptoTools.getString((Secret)keystorePassword);
            if (password.length() > 8) {
                password = password.substring(0, 8);
            }
            password = password.toUpperCase();
            ByteArrayLocator out = new ByteArrayLocator(new byte[1000], encrypted.getName());
            this.performDecrypt(encrypted, (ILocator)out, password.getBytes());
            return out.getBytes();
        }

        @Override
        public ICredential getKeyStoreCredential() {
            return new Credential(CommonKeyStore.DEFAULT_KEYSTORE_PASSWORD_NAME, Msg.getString("CommonKeyStore.TelepasswordLabel", new Object[0]), false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void performDecrypt(ILocator in, ILocator out, byte[] key) throws GeneralSecurityException, IOException {
            DESKeySpec dks = new DESKeySpec(key);
            SecretKeyFactory skf = SecretKeyFactory.getInstance("DES");
            SecretKey desKey = skf.generateSecret(dks);
            Cipher cipher = Cipher.getInstance("DES/CBC/PKCS5Padding");
            cipher.init(2, (Key)desKey, new IvParameterSpec(IV));
            InputStream is = null;
            OutputStream os = null;
            CipherOutputStream cos = null;
            try {
                is = in.getInputStream();
                os = out.getOutputStream();
                cos = new CipherOutputStream(os, cipher);
                StreamTools.copy((InputStream)is, (OutputStream)cos);
            }
            catch (Throwable throwable) {
                StreamTools.close((Closeable)is);
                StreamTools.close(cos);
                if (cos == null) {
                    StreamTools.close((Closeable)os);
                }
                throw throwable;
            }
            StreamTools.close((Closeable)is);
            StreamTools.close((Closeable)cos);
            if (cos == null) {
                StreamTools.close((Closeable)os);
            }
        }
    }
}

