/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.certificate.provider;

import de.intarsys.security.certificate.provider.CompositeCertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderRegistry;
import jakarta.annotation.PostConstruct;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SpringCertificateProviderRegistry
extends CompositeCertificateProvider
implements ICertificateProviderRegistry {
    private static final Logger Log = LoggerFactory.getLogger(SpringCertificateProviderRegistry.class);
    @Autowired(required=false)
    private List<ICertificateProvider> certificateProviders;

    public SpringCertificateProviderRegistry() {
        super("spring");
    }

    @PostConstruct
    public void init() {
        if (this.certificateProviders == null) {
            return;
        }
        for (ICertificateProvider provider : this.certificateProviders) {
            this.registerCertificateProvider(provider);
        }
    }

    @Override
    public void registerCertificateProvider(ICertificateProvider provider) {
        Log.info("certificate provider registry register {}", (Object)provider);
        super.registerCertificateProvider(provider);
    }

    @Override
    public void unregisterCertificateProvider(ICertificateProvider provider) {
        Log.info("certificate provider registry unregister {}", (Object)provider);
        super.unregisterCertificateProvider(provider);
    }
}

