/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes.sigg;

import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.QESTimestampReviewer;
import de.intarsys.security.app.validation.commonpki.qes.sigg.PACKAGE;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSQualification;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.timestamp.ITimestampInfo;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.security.validation.IVSTimestamp;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;

public class QESSigGTimestampReviewer
extends QESTimestampReviewer {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    public QESSigGTimestampReviewer() {
    }

    public QESSigGTimestampReviewer(int severity) {
        super(severity);
    }

    @Override
    protected CommonPKIProfile getValidityPolicy() {
        return CommonPKIProfile.QES_SigG;
    }

    @Override
    protected void validate(IVSTimestamp state, VSQualification qState) {
        super.validate(state, qState);
        ITimestampToken timestamp = state.getTimestamp();
        if (timestamp == null) {
            qState.invalidate(Msg.getString("QESSigGTimestampReviewer.tsDataMissing", new Object[0]));
        } else {
            try {
                ITimestampInfo tsInfo = timestamp.getTimestampInfo();
                if (tsInfo == null) {
                    qState.invalidate(Msg.getString("QESSigGTimestampReviewer.tsInfoMissing", new Object[0]));
                } else {
                    String policy = tsInfo.getPolicy();
                    if (ISISMTTObjectIdentifiers.id_isismtt_cp_accredited.getId().equals(policy)) {
                        qState.addMessage(ValidationMessage.createInfo(Msg.getString("QESSigGTimestampReviewer.tsInfoFoundSigGPolicy", new Object[0])));
                    }
                }
            }
            catch (IOException e) {
                qState.invalidate(CommonValidationMessages.ERROR_IO(e));
            }
        }
    }
}

