/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki.qes.sigg;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.EncodingAlgorithm;
import de.intarsys.security.algorithm.common.EncryptionAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.commonpki.qes.CommonPKIProfile;
import de.intarsys.security.app.validation.commonpki.qes.QESSignatureEntryReviewer;
import de.intarsys.security.app.validation.commonpki.qes.sigg.PACKAGE;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.standard.validation.VSQualification;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.standard.validation.commonpki.CryptoDates;
import de.intarsys.security.validation.IVSCertificate;
import de.intarsys.security.validation.IVSDigest;
import de.intarsys.security.validation.IVSMathematicalSignature;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.date.DateEnvironment;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.IMessageBundle;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Date;

public class QESSigGSignatureEntryReviewer
extends QESSignatureEntryReviewer {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);

    public QESSigGSignatureEntryReviewer() {
    }

    public QESSigGSignatureEntryReviewer(int severity) {
        super(severity);
    }

    protected void checkDigestAlgorithmQuality(Date sigDate, String digestAlgorithm, String expirationAlgorithm, Date expirationDate, VSQualification qState) {
        if (expirationAlgorithm.equals(digestAlgorithm)) {
            if (sigDate.after(expirationDate)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                qState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigDigestAlgorithmExpired", new Object[]{digestAlgorithm, formattedDate}));
                qState.setDigestAlgorithmUpToDate(false);
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.SigDigestAlgorithmExpired", new Object[]{digestAlgorithm, formattedDate});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                qState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkDigestAlgorithmQuality(IVSSignatureEntry state, VSQualification qState, Date sigDate) {
        IVSSignature sigState = state.getSignatureState();
        if (sigState != null) {
            for (IVSDigest digestState : sigState.getDigestStates()) {
                String digestAlgorithm = ((Algorithm)digestState.getAlgorithmSpec().getAlgorithm()).getCanonicalName();
                this.checkDigestAlgorithmQuality(sigDate, digestAlgorithm, DigestAlgorithm.ALG_SHA1.getCanonicalName(), CryptoDates.EXPIRATIONDATE_SIG_DIGEST_SHA1, qState);
                this.checkDigestAlgorithmQuality(sigDate, digestAlgorithm, "RIPEMD160", CryptoDates.EXPIRATIONDATE_SIG_DIGEST_RIPEMD160, qState);
            }
        }
    }

    protected void checkECDSAKeySize(Date sigDate, int keyBitSize, VSQualification qState) {
        if (keyBitSize < 0) {
            String msg = Msg.getString("QESSigGSignatureEntryReviewer.ErrorReadingKeysize", new Object[0]);
            qState.invalidate(ValidationMessage.createError(msg));
            qState.setSignatureAlgorithmUpToDate(false);
        } else {
            Date expirationDate = CryptoDates.getExpirationDateForECDSAKeySize(keyBitSize);
            if (sigDate.after(expirationDate)) {
                String message = Msg.getString("QESSigGSignatureEntryReviewer.signature.ECDSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                qState.invalidate(message);
                qState.setSignatureAlgorithmUpToDate(false);
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.ECDSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                qState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkRSAKeySize(Date sigDate, int keyBitSize, VSQualification qState) {
        if (keyBitSize < 0) {
            String msg = Msg.getString("QESSigGSignatureEntryReviewer.ErrorReadingKeysize", new Object[0]);
            qState.invalidate(ValidationMessage.createError(msg));
            qState.setSignatureAlgorithmUpToDate(false);
        } else if (keyBitSize < 1024) {
            qState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeTooShort", new Object[]{String.valueOf(keyBitSize)}));
            qState.setSignatureAlgorithmUpToDate(false);
        } else {
            Date expirationDate = CryptoDates.getExpirationDateForRSAKeySize(keyBitSize);
            if (sigDate.after(expirationDate)) {
                String message = Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                qState.invalidate(message);
                qState.setSignatureAlgorithmUpToDate(false);
            } else if (DateEnvironment.get().now().after(expirationDate)) {
                Object message = Msg.getString("QESSigGSignatureEntryReviewer.signature.RSAKeySizeExpired", new Object[]{String.valueOf(keyBitSize), FORMATTER.format(DateTools.toLocalDate((Date)expirationDate))});
                message = (String)message + " " + Msg.getString("QESSigGSignatureEntryReviewer.signature.ReducedAuthenticity", new Object[0]);
                qState.addMessage(ValidationMessage.createWarning((String)message));
            }
        }
    }

    protected void checkSignatureAlgorithmQuality(IVSSignatureEntry state, VSQualification qState, Date sigDate) {
        SignatureAlgorithm signatureAlgorithm;
        IVSMathematicalSignature sigState = state.getSignatureState().getSignatureState();
        if (sigState != null && (signatureAlgorithm = sigState.getSignatureAlgorithmSpec().getAlgorithm()).getEncryptionAlgorithm() == EncryptionAlgorithm.ALG_RSA) {
            Date expirationDate;
            EncodingAlgorithm encodingAlgorithm = signatureAlgorithm.getEncodingAlgorithm();
            if (encodingAlgorithm == EncodingAlgorithm.ALG_UNKNOWN) {
                qState.increaseState(2);
                qState.addMessage(ValidationMessage.createError(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigEncodingSchemaUnknown", new Object[0])));
            } else if ((encodingAlgorithm == EncodingAlgorithm.ALG_PKCS1Type1 || encodingAlgorithm == EncodingAlgorithm.ALG_PKCS1Type2) && sigDate.after(expirationDate = CryptoDates.EXPIRATIONDATE_SIG_RSA_PKCS1_v1_5)) {
                String formattedDate = FORMATTER.format(DateTools.toLocalDate((Date)expirationDate));
                qState.invalidate(Msg.getString("QESSigGSignatureEntryReviewer.signature.SigEncodingSchemaExpired", new Object[]{encodingAlgorithm.getName(), formattedDate}));
                qState.setDigestAlgorithmUpToDate(false);
            }
        }
    }

    @Override
    protected CommonPKIProfile getValidityPolicy() {
        return CommonPKIProfile.QES_SigG;
    }

    @Override
    protected void validate(IVSSignatureEntry state, VSQualification qState, IValidationParameters parameters) {
        super.validate(state, qState, parameters);
        Date sigDate = state.getReferenceDate();
        if (sigDate == null) {
            sigDate = DateEnvironment.get().now();
        }
        this.checkDigestAlgorithmQuality(state, qState, sigDate);
        this.checkSignatureAlgorithmQuality(state, qState, sigDate);
        IVSCertificate certState = state.getCertificateState();
        if (certState != null) {
            IX509PublicKeyCertificate signerCertificate = null;
            if (certState.getValidationTarget() != null) {
                signerCertificate = (IX509PublicKeyCertificate)certState.getValidationTarget().getImpl();
            }
            if (signerCertificate != null) {
                int keyBitSize = signerCertificate.getKeyBitSize();
                String algorithm = signerCertificate.getPublicKey().getAlgorithm();
                if ("RSA".equals(algorithm)) {
                    this.checkRSAKeySize(sigDate, keyBitSize, qState);
                } else if ("ECDSA".equals(algorithm) || "EC".equals(algorithm)) {
                    this.checkECDSAKeySize(sigDate, keyBitSize, qState);
                }
            }
        }
    }
}

