/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.security.app.validation.commonpki.CommonPKIOCSPService;
import de.intarsys.security.app.validation.commonpki.CommonPKIValidationContextFactory;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFacade;
import de.intarsys.security.certificate.provider.keystore.KeyStoreFactory;
import de.intarsys.security.privatekey.KeyCertificatePair;
import de.intarsys.security.privatekey.PrivateKeyTools;
import de.intarsys.security.standard.validation.commonpki.OCSPDepth;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.authenticate.ConstantPasswordProvider;
import de.intarsys.tools.authenticate.IPasswordProvider;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ClassResourceLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.ssl.SslContextProvider;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.util.Iterator;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPKIOCSPTools {
    private static final String OCSP_REQUEST_SIGNING_KEYSTORE_NAME = "intarsys OCSP Request Signing 2008.p12";
    private static final Secret OCSP_REQUEST_SIGNING_KEYSTORE_PASSWORD = Secret.hide((char[])"CABAReT".toCharArray());
    private static final Logger Log = LoggerFactory.getLogger(CommonPKIOCSPTools.class);
    private static KeyCertificatePair ocspSignatureEntity;

    public static void configureOCSPService(CommonPKIOCSPService ocspService, IArgs args) {
        ocspService.setRequestSignatureData("SHA1withRSA", CommonPKIOCSPTools.getOCSPSignatureEntity().getPrivateKey(), CommonPKIOCSPTools.getOCSPSignatureEntity().getCertificateChain());
        ocspService.setVerifyResult(true);
        try {
            SSLContext sslContext = SslContextProvider.get().createSslContext();
            ocspService.setSslContext(sslContext);
        }
        catch (IOException | GeneralSecurityException e) {
            Log.warn("Could not create SSL context for OCSP service", (Throwable)e);
        }
        ocspService.setOcspDepth((OCSPDepth)ArgTools.getEnumItem((IArgs)args, OCSPDepth.META, (String)"ocspDepth"));
        ocspService.setWarnOnNoURL(ArgTools.getBoolStrict((IArgs)args, (String)"ocspWarnOnNoURL", (boolean)true));
        ocspService.setDefaultAcceptPeriod(ArgTools.getLongStrict((IArgs)args, (String)"ocspDefaultAcceptPeriod", (long)10000L));
        ocspService.setCache(ValidationEnvironment.get().getOcspCache());
        ocspService.setConnectTimeout(ArgTools.getInt((IArgs)args, (String)"httpConnectTimeout", (int)5000));
        ocspService.setReadTimeout(ArgTools.getInt((IArgs)args, (String)"httpReadTimeout", (int)15000));
    }

    public static synchronized KeyCertificatePair getOCSPSignatureEntity() {
        if (ocspSignatureEntity == null) {
            try {
                ClassResourceLocator locator = new ClassResourceLocator(CommonPKIValidationContextFactory.class, OCSP_REQUEST_SIGNING_KEYSTORE_NAME);
                KeyStoreFacade keystore = (KeyStoreFacade)KeyStoreFactory.get().create((ILocator)locator);
                keystore.load(OCSP_REQUEST_SIGNING_KEYSTORE_PASSWORD);
                Iterator<IX509Certificate> certificates = keystore.getKeyEntities();
                if (certificates.hasNext()) {
                    IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)certificates.next();
                    PrivateKey key = PrivateKeyTools.getPrivateKey(certificate, (IPasswordProvider)new ConstantPasswordProvider(OCSP_REQUEST_SIGNING_KEYSTORE_PASSWORD));
                    ocspSignatureEntity = new KeyCertificatePair(key, certificate);
                }
            }
            catch (IOException | KeyStoreException | UnrecoverableKeyException e) {
                throw new InitializationException("Failed load OCSP signature entity; Is the Bouncy Castle provider registered?", (Throwable)e);
            }
        }
        return ocspSignatureEntity;
    }
}

