/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.commonpki;

import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.app.validation.EnumValidityModel;
import de.intarsys.security.app.validation.ICertificateChecker;
import de.intarsys.security.app.validation.ICertificatePathValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.X509SignatureValidator;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.PACKAGE;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.X509CertificatePath;
import de.intarsys.security.extension.common.ValidityModel;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.QCTools;
import de.intarsys.security.standard.validation.VSCRL;
import de.intarsys.security.standard.validation.VSCertificate;
import de.intarsys.security.standard.validation.VSCertificatePath;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.VSOCSP;
import de.intarsys.security.standard.validation.VSOCSPRequest;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.standard.validation.commonpki.CommonPKICertificatePathValidatorTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSSignature;
import de.intarsys.security.validation.Origin;
import de.intarsys.tools.date.DateTools;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.math.BigInteger;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.asn1.x509.NameConstraints;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.qualified.QCStatement;

public class CommonPKICertificatePathValidator
implements ICertificatePathValidator {
    protected static final String CERTIFICATE_POLICIES = "2.5.29.32";
    protected static final String POLICY_MAPPINGS = "2.5.29.33";
    protected static final String POLICY_CONSTRAINTS = "2.5.29.36";
    protected static final String BASIC_CONSTRAINTS = "2.5.29.19";
    protected static final String SUBJECT_ALTERNATIVE_NAME = "2.5.29.17";
    protected static final String NAME_CONSTRAINTS = "2.5.29.30";
    protected static final String KEY_USAGE = "2.5.29.15";
    protected static final String EXTENDED_KEY_USAGE = "2.5.29.37";
    protected static final String QC_STATEMENTS = "1.3.6.1.5.5.7.1.3";
    protected static final String AUTHORITY_INFO_ACCESS = "1.3.6.1.5.5.7.1.1";
    protected static final String OCSP_NOCHECK = "1.3.6.1.5.5.7.48.1.5";
    protected static final String DATE_OF_CERT_GEN = ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId();
    private static final String OID_ANY_POLICY = "2.5.29.32.0";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
    private final List<ICertificateChecker> certificateCheckers = new ArrayList<ICertificateChecker>();
    private boolean useOCSP = true;
    private boolean useCRL = true;

    public void addCertificateChecker(ICertificateChecker certificateChecker) {
        this.certificateCheckers.add(certificateChecker);
    }

    protected void basicCheckRevocationStatus(IX509Certificate certificate, IX509CertificatePath certificatePath, VSCertificate certificateState, IValidationParameters params) {
        IVSOCSP ocspState = this.checkRevocationStatusOCSP(certificate, certificatePath, params);
        IVSCRL crlState = null;
        Object requestState = ocspState.getSuccessfulRequestState();
        if (requestState == null) {
            if (this.isUseCRL()) {
                ((CommonValidationState)((Object)ocspState)).setSeverity(1);
            }
            crlState = this.checkRevocationStatusCRL(certificate, certificatePath, params);
        } else if (requestState.getOrigin() == null || requestState.getOrigin().isExternal()) {
            ValidationParameters offlineCrlParams = ValidationParameters.copy(params);
            offlineCrlParams.setCRLProvider((selector, url) -> Stream.empty());
            IVSCRL offlineCrlState = this.checkRevocationStatusCRL(certificate, certificatePath, offlineCrlParams);
            if (offlineCrlState.isValid()) {
                ((CommonValidationState)((Object)offlineCrlState)).setSeverity(2);
                crlState = offlineCrlState;
            }
        }
        certificateState.setOCSPState(ocspState);
        if (crlState == null) {
            crlState = new VSCRL(-1);
        }
        certificateState.setCRLState(crlState);
    }

    protected void checkCriticalExtensions(IX509Certificate certificate, IValidationParameters params, Set<String> criticalExtensions, VSCertificate certificateState) {
        for (ICertificateChecker certificateChecker : this.getCertificateCheckers()) {
            certificateChecker.checkCertificate(certificate, params, criticalExtensions, certificateState);
        }
    }

    protected void checkNames(IX509Certificate certificate, Subtrees permittedSubtrees, Subtrees excludedSubtrees, VSCertificate certificateState) {
        X500Principal principal = certificate.getSubjectX500Principal();
        try {
            ASN1Sequence dirName = (ASN1Sequence)ASN1Tools.create((byte[])principal.getEncoded());
            if (!CommonPKICertificatePathValidatorTools.checkPermittedDirName(permittedSubtrees.dirName, dirName)) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeDirName", new Object[0]));
            }
            if (!CommonPKICertificatePathValidatorTools.checkExcludedDirName(excludedSubtrees.dirName, dirName)) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeDirName", new Object[0]));
            }
        }
        catch (IOException e) {
            certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
        }
        ASN1Sequence asn1AltNames = null;
        try {
            asn1AltNames = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, SUBJECT_ALTERNATIVE_NAME);
            if (asn1AltNames != null) {
                GeneralNames altNames = (GeneralNames)GeneralNames.FACTORY.create((ASN1Encodable)asn1AltNames);
                for (de.intarsys.asn1.common.GeneralName altName : altNames.getNames()) {
                    if (altName.isRFC822Name()) {
                        String email = altName.getRFC822Name();
                        if (!CommonPKICertificatePathValidatorTools.checkPermittedEmail(permittedSubtrees.email, email)) {
                            certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeEMail", new Object[0]));
                        }
                        if (CommonPKICertificatePathValidatorTools.checkExcludedEmail(excludedSubtrees.email, email)) continue;
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeEMail", new Object[0]));
                        continue;
                    }
                    if (altName.isDNSName()) {
                        String dns = altName.getDNSName();
                        if (!CommonPKICertificatePathValidatorTools.checkPermittedDNS(permittedSubtrees.dns, dns)) {
                            certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeDNS", new Object[0]));
                        }
                        if (CommonPKICertificatePathValidatorTools.checkExcludedDNS(excludedSubtrees.dns, dns)) continue;
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeDNS", new Object[0]));
                        continue;
                    }
                    if (altName.isUniformResourceIdentifier()) {
                        String uri = altName.getUniformResourceIdentifier();
                        if (!CommonPKICertificatePathValidatorTools.checkPermittedURI(permittedSubtrees.uri, uri)) {
                            certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeURI", new Object[0]));
                        }
                        if (CommonPKICertificatePathValidatorTools.checkExcludedURI(excludedSubtrees.uri, uri)) continue;
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeURI", new Object[0]));
                        continue;
                    }
                    if (!altName.isIPAddress()) continue;
                    byte[] ip = altName.getIPAddress();
                    if (!CommonPKICertificatePathValidatorTools.checkPermittedIP(permittedSubtrees.ip, ip)) {
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeIP", new Object[0]));
                    }
                    if (CommonPKICertificatePathValidatorTools.checkExcludedIP(excludedSubtrees.ip, ip)) continue;
                    certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorPermittedSubtreeIP", new Object[0]));
                }
            }
        }
        catch (IOException e) {
            certificateState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, SUBJECT_ALTERNATIVE_NAME));
        }
    }

    protected void checkRevocationStatus(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params, VSCertificate certificateState) {
        if (CertificateTools.isSelfSigned(certificate)) {
            return;
        }
        byte[] nocheck = certificate.getExtensionValue(OCSP_NOCHECK);
        if (nocheck != null) {
            return;
        }
        this.basicCheckRevocationStatus(certificate, certificatePath, certificateState, params);
    }

    protected IVSCRL checkRevocationStatusCRL(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
        if (!this.isUseCRL()) {
            return new VSCRL();
        }
        return ValidationContext.get().getCRLService().validateCertificate(certificate, certificatePath, params);
    }

    protected IVSOCSP checkRevocationStatusOCSP(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters params) {
        if (!this.isUseOCSP()) {
            return this.createEmbeddedOCSPState(certificate, certificatePath, params);
        }
        return ValidationContext.get().getOCSPService().validateCertificate(certificate, certificatePath, params);
    }

    protected IVSOCSP createEmbeddedOCSPState(IX509Certificate certificate, IX509CertificatePath certificatePath, IValidationParameters parameters) {
        VSOCSP state = new VSOCSP();
        state.setSeverity(2);
        IExtendedValidationData validationData = parameters.getExtendedValidationData();
        if (validationData == null) {
            return state;
        }
        IX509PublicKeyCertificate issuerCertificate = certificatePath == null ? null : certificatePath.getIssuerCertificate(certificate);
        validationData.getOCSPResponses().forEach(ocsp -> {
            if (ocsp.getSingleResult(certificate, issuerCertificate) != null) {
                VSOCSPRequest requestState = new VSOCSPRequest((IOCSPResponse)ocsp, -1);
                requestState.setSeverity(2);
                requestState.setOrigin(Origin.embedded());
                state.addRequestState(requestState);
            }
        });
        return state;
    }

    protected BasicConstraints getBasicConstraints(IX509Certificate certificate) throws IOException {
        ASN1Primitive derBasicConstraints = CertificateTools.getExtensionValue(certificate, BASIC_CONSTRAINTS);
        if (derBasicConstraints == null) {
            return null;
        }
        BasicConstraints basicConstraints = BasicConstraints.getInstance((Object)derBasicConstraints);
        return basicConstraints;
    }

    public List<ICertificateChecker> getCertificateCheckers() {
        return this.certificateCheckers;
    }

    protected Date getDateOfIssue(IX509Certificate certificate) throws IOException {
        ASN1Primitive derDateOfCertGen = CertificateTools.getExtensionValue(certificate, DATE_OF_CERT_GEN);
        ASN1GeneralizedTime dateOfCertGen = ASN1GeneralizedTime.getInstance((Object)derDateOfCertGen);
        if (dateOfCertGen != null) {
            try {
                return dateOfCertGen.getDate();
            }
            catch (ParseException e) {
                IOException ioe = new IOException();
                ioe.initCause(e);
                throw ioe;
            }
        }
        return certificate.getNotBefore();
    }

    protected Set<String> getExplicitPolicies(IX509Certificate certificate) throws IOException {
        ASN1Sequence derQCStatements;
        HashSet<String> explicitPolicies = new HashSet<String>();
        ASN1Sequence derExplicitPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, CERTIFICATE_POLICIES);
        if (derExplicitPolicies != null) {
            Enumeration e = derExplicitPolicies.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derPolicyInformation = (ASN1Encodable)e.nextElement();
                PolicyInformation policyInformation = PolicyInformation.getInstance((Object)derPolicyInformation);
                ASN1ObjectIdentifier policyIdentifier = policyInformation.getPolicyIdentifier();
                explicitPolicies.add(policyIdentifier.getId());
            }
        }
        if ((derQCStatements = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, QC_STATEMENTS)) != null) {
            Enumeration e = derQCStatements.getObjects();
            while (e.hasMoreElements()) {
                ASN1Encodable derQCStatement = (ASN1Encodable)e.nextElement();
                QCStatement statement = QCStatement.getInstance((Object)derQCStatement);
                ASN1ObjectIdentifier statementIdentifier = statement.getStatementId();
                explicitPolicies.add(statementIdentifier.getId());
            }
        }
        return explicitPolicies;
    }

    protected Set<String> getMappedPolicies(IX509Certificate certificate, Set<String> acceptablePolicies) throws IOException {
        HashSet<String> mappedPolicies = new HashSet<String>();
        ASN1Sequence derMappedPolicies = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, POLICY_MAPPINGS);
        if (derMappedPolicies != null) {
            Enumeration e = derMappedPolicies.getObjects();
            while (e.hasMoreElements()) {
                ASN1Sequence derPolicyMapping = (ASN1Sequence)e.nextElement();
                ASN1ObjectIdentifier derIssuerDomainPolicy = (ASN1ObjectIdentifier)derPolicyMapping.getObjectAt(0);
                ASN1ObjectIdentifier derSubjectDomainPolicy = (ASN1ObjectIdentifier)derPolicyMapping.getObjectAt(1);
                String issuerDomainPolicy = derIssuerDomainPolicy.getId();
                String subjectDomainPolicy = derSubjectDomainPolicy.getId();
                if (!acceptablePolicies.contains(issuerDomainPolicy)) continue;
                mappedPolicies.add(subjectDomainPolicy);
            }
        }
        return mappedPolicies;
    }

    protected IX509CertificatePath getPathSegment(IX509Certificate certificate, IX509CertificatePath certPath) {
        ArrayList<IX509Certificate> certificatePathSegment = new ArrayList<IX509Certificate>();
        boolean ok = false;
        for (int i = 1; i <= certPath.size(); ++i) {
            IX509Certificate cert = certPath.getCertificate(i);
            certificatePathSegment.add(cert);
            if (!cert.equals(certificate)) continue;
            ok = true;
            break;
        }
        if (!ok) {
            certificatePathSegment = new ArrayList();
            certificatePathSegment.add(certificate);
        }
        return new X509CertificatePath(certificatePathSegment);
    }

    protected Set<String> intersection(Set<String> policySet1, Set<String> policySet2) {
        if (this.isAnyPolicy(policySet1)) {
            if (this.isAnyPolicy(policySet2)) {
                return new HashSet<String>();
            }
            return policySet2;
        }
        if (this.isAnyPolicy(policySet2)) {
            return policySet1;
        }
        HashSet<String> intersection = new HashSet<String>();
        for (String policy : policySet1) {
            if (!policySet2.contains(policy)) continue;
            intersection.add(policy);
        }
        for (String policy : policySet2) {
            if (!policySet1.contains(policy)) continue;
            intersection.add(policy);
        }
        return intersection;
    }

    protected boolean isAnyPolicy(Set<String> policySet) {
        return policySet == null || policySet.isEmpty() || policySet.contains(OID_ANY_POLICY);
    }

    protected boolean isChainModelApplicable(IX509CertificatePath certPath) {
        try {
            return QCTools.isQualificationPostulated(certPath) || QCTools.isBNETZAIssued(certPath);
        }
        catch (IOException e) {
            return false;
        }
    }

    protected boolean isChainModelApplicableRevoc(IVSCertificatePath pathState) {
        return false;
    }

    public boolean isUseCRL() {
        return this.useCRL;
    }

    public boolean isUseOCSP() {
        return this.useOCSP;
    }

    protected boolean maySignCert(IX509Certificate certificate) {
        if (!(certificate instanceof IX509PublicKeyCertificate)) {
            return false;
        }
        if (!CertificateTools.isCriticalExtension(certificate, KEY_USAGE)) {
            return true;
        }
        ASN1Primitive derKeyUsage = null;
        try {
            derKeyUsage = CertificateTools.getExtensionValue(certificate, KEY_USAGE);
        }
        catch (IOException e) {
            return false;
        }
        if (derKeyUsage == null) {
            return false;
        }
        KeyUsage keyUsage = KeyUsage.getInstance((Object)derKeyUsage);
        return keyUsage.hasUsages(4);
    }

    public void setUseCRL(boolean useCRL) {
        this.useCRL = useCRL;
    }

    public void setUseOCSP(boolean useOCSP) {
        this.useOCSP = useOCSP;
    }

    protected Set<String> union(Set<String> policySet1, Set<String> policySet2) {
        if (this.isAnyPolicy(policySet1)) {
            if (this.isAnyPolicy(policySet2)) {
                return new HashSet<String>();
            }
            return policySet2;
        }
        if (this.isAnyPolicy(policySet2)) {
            return policySet1;
        }
        HashSet<String> union = new HashSet<String>();
        union.addAll(policySet1);
        union.addAll(policySet2);
        return union;
    }

    protected void updateNameSubtrees(IX509Certificate certificate, Subtrees permittedSubtrees, Subtrees excludedSubtrees) throws IOException {
        ASN1Primitive derNameConstraints = CertificateTools.getExtensionValue(certificate, NAME_CONSTRAINTS);
        if (derNameConstraints != null) {
            GeneralSubtree[] excluded;
            NameConstraints nameConstraints = NameConstraints.getInstance((Object)derNameConstraints);
            GeneralSubtree[] permitted = nameConstraints.getPermittedSubtrees();
            if (permitted != null) {
                block14: for (GeneralSubtree subtree : permitted) {
                    GeneralName base = subtree.getBase();
                    switch (base.getTagNo()) {
                        case 1: {
                            permittedSubtrees.email = CommonPKICertificatePathValidatorTools.intersectEmail(permittedSubtrees.email, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block14;
                        }
                        case 2: {
                            permittedSubtrees.dns = CommonPKICertificatePathValidatorTools.intersectDNS(permittedSubtrees.dns, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block14;
                        }
                        case 4: {
                            permittedSubtrees.email = CommonPKICertificatePathValidatorTools.intersectDirName(permittedSubtrees.email, (ASN1Sequence)base.getName().toASN1Primitive());
                            continue block14;
                        }
                        case 6: {
                            permittedSubtrees.uri = CommonPKICertificatePathValidatorTools.intersectURI(permittedSubtrees.uri, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block14;
                        }
                        case 7: {
                            permittedSubtrees.ip = CommonPKICertificatePathValidatorTools.intersectIP(permittedSubtrees.ip, ASN1OctetString.getInstance((Object)base.getName()).getOctets());
                        }
                    }
                }
            }
            if ((excluded = nameConstraints.getExcludedSubtrees()) != null) {
                block15: for (GeneralSubtree subtree : excluded) {
                    GeneralName base = subtree.getBase();
                    switch (base.getTagNo()) {
                        case 1: {
                            excludedSubtrees.email = CommonPKICertificatePathValidatorTools.unionEmail(excludedSubtrees.email, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block15;
                        }
                        case 2: {
                            excludedSubtrees.dns = CommonPKICertificatePathValidatorTools.unionDNS(excludedSubtrees.dns, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block15;
                        }
                        case 4: {
                            excludedSubtrees.dirName = CommonPKICertificatePathValidatorTools.unionDirName(excludedSubtrees.dirName, (ASN1Sequence)base.getName().toASN1Primitive());
                            continue block15;
                        }
                        case 6: {
                            excludedSubtrees.uri = CommonPKICertificatePathValidatorTools.unionURI(excludedSubtrees.uri, DERIA5String.getInstance((Object)base.getName()).getString());
                            continue block15;
                        }
                        case 7: {
                            excludedSubtrees.ip = CommonPKICertificatePathValidatorTools.unionIP(excludedSubtrees.ip, ASN1OctetString.getInstance((Object)base.getName()).getOctets());
                        }
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IVSCertificatePath validateCertificatePath(IX509CertificatePath certPath, IValidationParameters params) {
        EnumValidityModel model = null;
        IX509Certificate leafCertificate = certPath.getLeafCertificate();
        try {
            ValidityModel extValidityModel = CertificateTools.getValidityModel(leafCertificate);
            if (extValidityModel != null && (model = EnumValidityModel.lookupItem(extValidityModel.getId())) != null) {
                // empty if block
            }
        }
        catch (IOException e) {
            VSCertificatePath state = new VSCertificatePath(certPath);
            state.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, "1.3.6.1.4.1.8301.3.5"));
            return state;
        }
        if (model == null) {
            model = params.getValidityModel();
        }
        if (model == null) {
            throw new IllegalArgumentException("model is null");
        }
        EnumValidityModel firstRun = null;
        EnumValidityModel fallbackRun = null;
        if (model == EnumValidityModel.CHAIN || model == EnumValidityModel.HYBRID || model == EnumValidityModel.SHELL) {
            firstRun = model;
        } else if (model == EnumValidityModel.HYBRID_FALLBACK) {
            firstRun = EnumValidityModel.HYBRID;
            fallbackRun = EnumValidityModel.CHAIN;
        } else {
            if (model != EnumValidityModel.SHELL_FALLBACK) {
                throw new IllegalArgumentException("'model' not supported");
            }
            firstRun = EnumValidityModel.SHELL;
            fallbackRun = EnumValidityModel.CHAIN;
        }
        VSCertificatePath state = this.validateCertificatePath(certPath, params, firstRun == EnumValidityModel.CHAIN);
        state.setValidationModel(firstRun.getLabel());
        if (fallbackRun != null && state.isInvalid() && this.isChainModelApplicable(certPath)) {
            state = this.validateCertificatePath(certPath, params, fallbackRun == EnumValidityModel.CHAIN);
            state.setValidationModel(fallbackRun.getLabel());
        }
        return state;
    }

    protected VSCertificatePath validateCertificatePath(IX509CertificatePath certPath, IValidationParameters params, boolean chainModel) {
        VSCertificatePath certPathState = new VSCertificatePath(certPath, 0);
        certPathState.setChainingOk(true);
        int n = certPath.size();
        Subtrees permittedSubtrees = new Subtrees();
        Subtrees excludedSubtrees = new Subtrees();
        Set<String> acceptablePolicySet = new HashSet<String>();
        int explicitPolicy = n + 1;
        int policyMapping = n + 1;
        boolean validate = true;
        for (int i = 1; i <= n; ++i) {
            Set<String> intersection;
            ValidationParameters myParams;
            IX509PublicKeyCertificate issuerCertificate;
            VSCertificate certificateState;
            IX509Certificate certificate;
            block55: {
                certificate = certPath.getCertificate(i);
                certificateState = new VSCertificate(certificate, 0);
                issuerCertificate = null;
                if (i > 1) {
                    issuerCertificate = (IX509PublicKeyCertificate)certPath.getCertificate(i - 1);
                } else if (CertificateTools.isSelfSigned(certificate)) {
                    issuerCertificate = (IX509PublicKeyCertificate)certificate;
                }
                if (issuerCertificate != null) {
                    this.verifySignature(certificate, issuerCertificate, certificateState);
                    if (!certificateState.getSignatureState().isValid()) {
                        certPathState.setChainingOk(false);
                    }
                    if (certificateState.isInvalid()) {
                        certPathState.addCertificateState(certificateState);
                        validate = false;
                        continue;
                    }
                }
                if (!validate) {
                    certificateState.setState(-1);
                    certPathState.addCertificateState(certificateState);
                    continue;
                }
                myParams = ValidationParameters.copy(params);
                if (i < n) {
                    IX509Certificate issuedCertificate = certPath.getCertificate(i + 1);
                    try {
                        Date dateOfIssue = this.getDateOfIssue(issuedCertificate);
                        if (dateOfIssue.before(certificate.getNotBefore()) || dateOfIssue.after(certificate.getNotAfter())) {
                            certPathState.setChainingOk(false);
                        }
                        if (!chainModel) break block55;
                        myParams.setDateToTest(dateOfIssue, true);
                    }
                    catch (IOException e) {
                        certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
                        certPathState.addCertificateState(certificateState);
                        validate = false;
                        continue;
                    }
                }
            }
            Date refTime = myParams.getDateToTest();
            LocalDate refDate = DateTools.toLocalDate((Date)refTime);
            certificateState.setReferenceDate(refTime);
            VSDefault validityPeriodState = new VSDefault();
            if (refTime.before(certificate.getNotBefore())) {
                validityPeriodState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorCertificateNotYetValid", new Object[]{FORMATTER.format(refDate)}));
            } else if (refTime.after(certificate.getNotAfter())) {
                validityPeriodState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorCertificateExpired", new Object[]{FORMATTER.format(refDate)}));
            } else {
                validityPeriodState.increaseState(0);
                validityPeriodState.addMessage(ValidationMessage.createInfo(Msg.getString("CommonPKICertificatePathValidator.InfoTimeCheckSuccesful", new Object[]{FORMATTER.format(refDate)})));
            }
            certificateState.setValidityPeriodState(validityPeriodState);
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            if (issuerCertificate != null) {
                this.checkRevocationStatus(certificate, this.getPathSegment(certificate, certPath), myParams, certificateState);
            }
            if (issuerCertificate != null && !issuerCertificate.getSubjectX500Principal().equals(certificate.getIssuerX500Principal())) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorNotCorrectlyChained", new Object[0]));
            }
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            if (i < n) {
                BasicConstraints basicConstraints = null;
                try {
                    basicConstraints = this.getBasicConstraints(certificate);
                }
                catch (IOException e) {
                    certificateState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, BASIC_CONSTRAINTS));
                }
                if (basicConstraints != null) {
                    int currentPathLength;
                    BigInteger maxPathLength;
                    if (!basicConstraints.isCA()) {
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorCAFlagMissing", new Object[0]));
                    }
                    if ((maxPathLength = basicConstraints.getPathLenConstraint()) != null && (currentPathLength = n - 1 - i) > maxPathLength.intValue()) {
                        certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorFollowingPathTooLong", new Object[0]));
                    }
                }
                if (!this.maySignCert(certificate)) {
                    certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorCertificateMustNotSignCerts", new Object[0]));
                }
            }
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            if (certificate instanceof IX509PublicKeyCertificate) {
                this.checkNames(certificate, permittedSubtrees, excludedSubtrees, certificateState);
            }
            try {
                this.updateNameSubtrees(certificate, permittedSubtrees, excludedSubtrees);
            }
            catch (IOException e) {
                certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
            }
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            Set<String> explicitPolicies = null;
            try {
                explicitPolicies = this.getExplicitPolicies(certificate);
            }
            catch (IOException e) {
                certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
            }
            if (explicitPolicy > i && !this.isAnyPolicy(myParams.getInitialPolicies()) && (intersection = this.intersection(explicitPolicies, myParams.getInitialPolicies())).isEmpty()) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorInvalidPolicies", new Object[0]));
            }
            Set<String> mappedPolicies = null;
            try {
                mappedPolicies = this.getMappedPolicies(certificate, acceptablePolicySet);
            }
            catch (IOException e) {
                certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
            }
            if (policyMapping > i && !mappedPolicies.isEmpty()) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorInvalidPolicyMapping", new Object[0]));
            }
            Set<String> intersection2 = this.intersection(explicitPolicies, acceptablePolicySet);
            if (CertificateTools.isCriticalExtension(certificate, CERTIFICATE_POLICIES) && !this.isAnyPolicy(acceptablePolicySet) && intersection2.isEmpty()) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorInvalidPolicies", new Object[0]));
            }
            acceptablePolicySet = intersection2;
            try {
                mappedPolicies = this.getMappedPolicies(certificate, acceptablePolicySet);
            }
            catch (IOException e) {
                certificateState.invalidate(CommonValidationMessages.ERROR_IO(e));
            }
            acceptablePolicySet = this.union(mappedPolicies, acceptablePolicySet);
            intersection2 = this.intersection(myParams.getInitialPolicies(), acceptablePolicySet);
            if (!this.isAnyPolicy(myParams.getInitialPolicies()) && intersection2.isEmpty()) {
                certificateState.invalidate(Msg.getString("CommonPKICertificatePathValidator.ErrorInvalidPolicies", new Object[0]));
            }
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            ASN1Sequence derPolicyConstraints = null;
            try {
                derPolicyConstraints = (ASN1Sequence)CertificateTools.getExtensionValue(certificate, POLICY_CONSTRAINTS);
            }
            catch (IOException e) {
                certificateState.invalidate(CommonValidationMessages.ERROR_IO_EXTENSION(e, POLICY_CONSTRAINTS));
            }
            if (derPolicyConstraints != null) {
                Enumeration e = derPolicyConstraints.getObjects();
                while (e.hasMoreElements()) {
                    ASN1TaggedObject policyConstraint = (ASN1TaggedObject)e.nextElement();
                    switch (policyConstraint.getTagNo()) {
                        case 0: {
                            int r = ASN1Integer.getInstance((Object)policyConstraint).getValue().intValue();
                            explicitPolicy = Math.min(r + i, explicitPolicy);
                            break;
                        }
                        case 1: {
                            int q = ASN1Integer.getInstance((Object)policyConstraint).getValue().intValue();
                            policyMapping = Math.min(q + i, policyMapping);
                        }
                    }
                }
            }
            if (certificateState.isInvalid()) {
                certPathState.addCertificateState(certificateState);
                validate = false;
                continue;
            }
            HashSet<String> criticalExtensions = new HashSet<String>();
            if (certificate.getCriticalExtensionOIDs() != null) {
                criticalExtensions.addAll(certificate.getCriticalExtensionOIDs());
            }
            criticalExtensions.remove(KEY_USAGE);
            criticalExtensions.remove(EXTENDED_KEY_USAGE);
            criticalExtensions.remove(CERTIFICATE_POLICIES);
            criticalExtensions.remove(POLICY_MAPPINGS);
            criticalExtensions.remove(POLICY_CONSTRAINTS);
            criticalExtensions.remove(BASIC_CONSTRAINTS);
            criticalExtensions.remove(SUBJECT_ALTERNATIVE_NAME);
            criticalExtensions.remove(NAME_CONSTRAINTS);
            criticalExtensions.remove(AUTHORITY_INFO_ACCESS);
            criticalExtensions.remove(QC_STATEMENTS);
            criticalExtensions.remove(OCSP_NOCHECK);
            criticalExtensions.remove(DATE_OF_CERT_GEN);
            this.checkCriticalExtensions(certificate, myParams, criticalExtensions, certificateState);
            if (!criticalExtensions.isEmpty()) {
                for (String extensionId : criticalExtensions) {
                    certificateState.invalidate(CommonValidationMessages.ERROR_UNPROCESSED_CRITICAL_EXTENSION(extensionId));
                }
            }
            certPathState.addCertificateState(certificateState);
            if (!certificateState.isInvalid()) continue;
            validate = false;
        }
        return certPathState;
    }

    protected void verifySignature(IX509Certificate certificate, IX509PublicKeyCertificate issuerCertificate, VSCertificate certificateState) {
        X509SignatureValidator<IX509Certificate> validator = X509SignatureValidator.createCertificateInstance();
        IVSSignature state = validator.validate(certificate, issuerCertificate);
        certificateState.setSignatureState(state);
    }

    private static class Subtrees {
        private Set email = new HashSet();
        private Set dns = new HashSet();
        private Set uri = new HashSet();
        private Set ip = new HashSet();
        private Set dirName = new HashSet();

        private Subtrees() {
        }
    }
}

