/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.validation.common;

import de.intarsys.security.app.validation.CommonSignatureContainerValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.common.IStateCachingStrategy;
import de.intarsys.security.app.validation.common.StateCachingStrategy;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.tools.digest.IDigest;

public abstract class ExtendedSignatureContainerValidator
extends CommonSignatureContainerValidator {
    private IStateCachingStrategy stateCachingStrategy;

    protected ExtendedSignatureContainerValidator() {
    }

    protected abstract IVSSignatureContainer basicValidate(ISignatureContainer var1, IDigest var2, IValidationParameters var3);

    public IStateCachingStrategy getStateCachingStrategy() {
        if (this.stateCachingStrategy == null) {
            this.stateCachingStrategy = StateCachingStrategy.noCache();
        }
        return this.stateCachingStrategy;
    }

    public void setStateCachingStrategy(IStateCachingStrategy stateCachingStrategy) {
        this.stateCachingStrategy = stateCachingStrategy;
    }

    public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
        IVSSignatureContainer containerState = (IVSSignatureContainer)this.getStateCachingStrategy().getCachedState(signatureContainer);
        if (containerState != null) {
            return containerState;
        }
        containerState = this.basicValidate(signatureContainer, digest, parameters);
        this.getStateCachingStrategy().cacheState(signatureContainer, containerState);
        return containerState;
    }
}

