/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.algorithm.ec;

import de.intarsys.tools.collection.ByteArrayTools;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;

public class EcTools {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);

    public static ECPoint decodeECPointX9Uncompressed(byte[] encoded) {
        int offset = 1;
        if (encoded[0] != 4) {
            offset = 0;
        } else if (encoded.length % 2 == 0) {
            offset = 0;
        }
        int numLength = (encoded.length - offset) / 2;
        byte[] xEnc = new byte[numLength];
        byte[] yEnc = new byte[numLength];
        System.arraycopy(encoded, offset, xEnc, 0, xEnc.length);
        System.arraycopy(encoded, xEnc.length + offset, yEnc, 0, yEnc.length);
        return new ECPoint(new BigInteger(1, xEnc), new BigInteger(1, yEnc));
    }

    public static byte[] encodeECPointX9Uncompressed(EllipticCurve curve, ECPoint point) {
        int qLength = EcTools.getKeyByteSize(curve);
        byte[] xArr = ByteArrayTools.toBytes((BigInteger)point.getAffineX(), (int)qLength);
        byte[] yArr = ByteArrayTools.toBytes((BigInteger)point.getAffineY(), (int)qLength);
        byte[] result = new byte[1 + 2 * qLength];
        result[0] = 4;
        System.arraycopy(xArr, 0, result, 1, xArr.length);
        System.arraycopy(yArr, 0, result, 1 + qLength, yArr.length);
        return result;
    }

    public static byte[] getCompressedPoint(EllipticCurve curve, ECPoint point) {
        int byteSize = EcTools.getKeyByteSize(curve);
        BigInteger x = point.getAffineX();
        byte[] bytes = ByteArrayTools.toBytes((BigInteger)x, (int)byteSize);
        return bytes;
    }

    public static int getKeyBitSize(ECParameterSpec ecParameterSpec) {
        return ecParameterSpec.getCurve().getField().getFieldSize();
    }

    public static int getKeyBitSize(EllipticCurve curve) {
        return curve.getField().getFieldSize();
    }

    public static int getKeyBitSize(PublicKey publicKey) {
        ECParameterSpec ecParameterSpec = ((ECPublicKey)publicKey).getParams();
        return EcTools.getKeyBitSize(ecParameterSpec);
    }

    public static int getKeyByteSize(ECParameterSpec ecParameterSpec) {
        return (EcTools.getKeyBitSize(ecParameterSpec) + 7) / 8;
    }

    public static int getKeyByteSize(EllipticCurve curve) {
        return (EcTools.getKeyBitSize(curve) + 7) / 8;
    }

    public static int getKeyByteSize(PublicKey publicKey) {
        return (EcTools.getKeyBitSize(publicKey) + 7) / 8;
    }

    public static String getSignatureCurve(PublicKey key) {
        byte[] encodedKey;
        SubjectPublicKeyInfo spki;
        AlgorithmIdentifier algid;
        if (key instanceof ECPublicKey && (algid = (spki = SubjectPublicKeyInfo.getInstance((Object)ASN1Sequence.getInstance((Object)(encodedKey = key.getEncoded())))).getAlgorithm()) != null && algid.getAlgorithm().equals((ASN1Primitive)X9ObjectIdentifiers.id_ecPublicKey)) {
            ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)algid.getParameters();
            return oid.toString();
        }
        return null;
    }

    public static boolean isOnCurve(EllipticCurve curve, ECPoint g, KeyPair keyPair) {
        ECPublicKey publicKey = (ECPublicKey)keyPair.getPublic();
        ECPrivateKey privateKey = (ECPrivateKey)keyPair.getPrivate();
        ECPoint refPublicKey = EcTools.opMultiply(curve, g, privateKey.getS());
        return publicKey.getW().equals(refPublicKey);
    }

    public static ECPoint opAdd(EllipticCurve curve, ECPoint a, ECPoint b) {
        if (a == ECPoint.POINT_INFINITY) {
            return b;
        }
        if (b == ECPoint.POINT_INFINITY) {
            return a;
        }
        BigInteger p = ((ECFieldFp)curve.getField()).getP();
        if (a.getAffineX().equals(b.getAffineX())) {
            if (a.getAffineY().equals(b.getAffineY())) {
                return EcTools.opTwice(curve, a);
            }
            return ECPoint.POINT_INFINITY;
        }
        BigInteger subY = b.getAffineY().subtract(a.getAffineY()).mod(p);
        BigInteger subX = b.getAffineX().subtract(a.getAffineX()).mod(p);
        BigInteger gamma = subY.multiply(subX.modInverse(p)).mod(p);
        BigInteger x3 = gamma.multiply(gamma).subtract(a.getAffineX()).subtract(b.getAffineX()).mod(p);
        BigInteger y3 = gamma.multiply(a.getAffineX().subtract(x3)).subtract(a.getAffineY()).mod(p);
        return new ECPoint(x3, y3);
    }

    public static ECPoint opMultiply(EllipticCurve curve, ECPoint point, BigInteger k) {
        if (point == ECPoint.POINT_INFINITY) {
            return ECPoint.POINT_INFINITY;
        }
        if (k.signum() == 0) {
            return ECPoint.POINT_INFINITY;
        }
        ECPoint q = ECPoint.POINT_INFINITY;
        int t = k.bitLength();
        for (int i = 0; i < t; ++i) {
            if (k.testBit(i)) {
                q = EcTools.opAdd(curve, q, point);
            }
            point = EcTools.opTwice(curve, point);
        }
        return q;
    }

    public static ECPoint opTwice(EllipticCurve curve, ECPoint point) {
        if (point == ECPoint.POINT_INFINITY) {
            return ECPoint.POINT_INFINITY;
        }
        if (point.getAffineY().signum() == 0) {
            return ECPoint.POINT_INFINITY;
        }
        BigInteger p = ((ECFieldFp)curve.getField()).getP();
        BigInteger temp1 = point.getAffineX().multiply(point.getAffineX()).multiply(THREE).add(curve.getA()).mod(p);
        BigInteger temp2 = point.getAffineY().multiply(TWO).mod(p);
        BigInteger gamma = temp1.multiply(temp2.modInverse(p)).mod(p);
        BigInteger x3 = gamma.multiply(gamma).subtract(point.getAffineX().multiply(TWO)).mod(p);
        BigInteger y3 = gamma.multiply(point.getAffineX().subtract(x3)).subtract(point.getAffineY()).mod(p);
        return new ECPoint(x3, y3);
    }

    public static byte[] sanitizeECPointX9Uncompressed(byte[] encoded) {
        if (encoded[0] != 4) {
            return ByteArrayTools.concat((byte[][])new byte[][]{{4}, encoded});
        }
        if (encoded.length % 2 == 0) {
            return ByteArrayTools.concat((byte[][])new byte[][]{{4}, encoded});
        }
        return encoded;
    }
}

