/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.xmp;

import de.intarsys.security.method.pdf.xmp.XMPPropertyDefinition;
import de.intarsys.security.method.pdf.xmp.XMPSchemaBase;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import org.jempbox.xmp.XMPMetadata;
import org.w3c.dom.Element;

public class XMPSchemaSignature
extends XMPSchemaBase {
    public static final String DEFAULT_NAMESPACE_PREFIX = "issign";
    public static final String NAMESPACE_URI = "http://intarsys.de/signature/1.0";
    public static final String DESCRIPTION = "Signature data";
    private static final Collection<XMPPropertyDefinition> PROPERTY_DEFINITIONS = Collections.unmodifiableList(Arrays.asList(new XMPPropertyDefinition("signatureData", "Text", "external", "Base64 encoded data that describes the signature")));

    public XMPSchemaSignature(Element element, String prefix) {
        super(element, prefix, NAMESPACE_URI, DESCRIPTION, PROPERTY_DEFINITIONS);
    }

    public XMPSchemaSignature(XMPMetadata parent) {
        super(parent, DEFAULT_NAMESPACE_PREFIX, NAMESPACE_URI, DESCRIPTION, PROPERTY_DEFINITIONS);
    }

    public byte[] getSignatureData() {
        String data = this.getTextProperty(this.prefix + ":signatureData");
        return Base64.getDecoder().decode(data);
    }

    public void setSignatureData(byte[] data) {
        String base64 = Base64.getEncoder().encodeToString(data);
        this.setTextProperty(this.prefix + ":signatureData", base64);
    }
}

