/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.security.method.pdf.signature.IDocumentChangeLog;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.validation.IChangeProvider;
import de.intarsys.security.validation.IDocumentChange;
import java.io.IOException;
import java.util.List;

public class PDFChangeProvider
implements IChangeProvider {
    private List<IDocumentChange> changes;
    private PDFSignatureContainerEntry signatureContainerEntry;

    public PDFChangeProvider(PDFSignatureContainerEntry signatureEntry) {
        this.signatureContainerEntry = signatureEntry;
    }

    public List<IDocumentChange> calculateSubsequentChanges() throws IOException {
        COSTools.IRevision signedRevision = this.getSignatureContainerEntry().getSignedRevision();
        if (signedRevision == null) {
            throw new IOException("Unable to determine changes.");
        }
        IDocumentChangeLog changeLog = this.getSignatureContainerEntry().getSignatureContainer().getDocumentChangeLog();
        try {
            return changeLog.getChangesAfter(signedRevision);
        }
        catch (COSLoadException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public PDFSignatureContainerEntry getSignatureContainerEntry() {
        return this.signatureContainerEntry;
    }

    public List<IDocumentChange> getSubsequentChanges() throws IOException {
        if (this.changes == null) {
            this.changes = this.calculateSubsequentChanges();
        }
        return this.changes;
    }
}

