/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.security.method.pdf.signature.ISignatureContainerFactory;
import de.intarsys.security.method.pdf.signature.Pkcs7Sha1SignatureContainer;
import de.intarsys.security.signature.ISignatureContainer;
import java.io.IOException;

public class SignatureFactoryPkcs7Sha1
implements ISignatureContainerFactory {
    public static final COSName CN_ADOBE_PKCS7_SHA1 = COSName.constant((String)"adbe.pkcs7.sha1");

    @Override
    public ISignatureContainer createSignatureContainer(PDSignature pdSignature) throws IOException {
        CMS cms;
        byte[] pkcs7Bytes = pdSignature.getContentBytes();
        if (pkcs7Bytes.length == 0) {
            return null;
        }
        try {
            cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])pkcs7Bytes);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Cannot parse CMS");
        }
        return new Pkcs7Sha1SignatureContainer(cms);
    }

    @Override
    public COSName getEncoding() {
        return CN_ADOBE_PKCS7_SHA1;
    }

    @Override
    public COSName getName() {
        return null;
    }
}

