/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.signature.SignatureContainerEntryReviewer;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.method.cms.attribute.encoder.CommitmentTypeIndicationEncoder;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SignaturePolicyIdentifierEncoder;
import de.intarsys.security.method.cms.attribute.encoder.SignerAttributesV2Encoder;
import de.intarsys.security.method.cms.attribute.encoder.SigningCertificateEncoder;
import de.intarsys.security.method.cms.attribute.encoder.TimestampEncoder;
import de.intarsys.security.method.cms.signature.CommonCMSSignatureContainerBuilderFactory;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.cms.validation.ResultValidationDataAppender;
import de.intarsys.security.method.common.signature.AdESEnvironment;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.SignaturePolicyValidator;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Collection;
import java.util.List;

@SingletonClass
public class CMSSignatureContainerBuilderFactoryPAdESEnhanced
extends CommonCMSSignatureContainerBuilderFactory {
    private static final CMSSignatureContainerBuilderFactoryPAdESEnhanced INSTANCE = new CMSSignatureContainerBuilderFactoryPAdESEnhanced();

    public static CMSSignatureContainerBuilderFactoryPAdESEnhanced get() {
        return INSTANCE;
    }

    public String getLabel() {
        return "PAdES baseline";
    }

    protected void prepareCMSSigner(ICMSSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
        ConformanceLevel level;
        List attrCerts;
        ICommitmentTypeIndication commitmentTypeIndication;
        super.prepareCMSSigner(builder, args);
        builder.setIncludeCertificates(AdESSignerTools.isIncludeCertificates((IArgs)args));
        builder.addAttributeProvider((IAttributeEncoder)new SigningCertificateEncoder());
        IPolicyReference signaturePolicy = AdESSignerTools.getSignaturePolicy((IArgs)args);
        if (signaturePolicy != null) {
            builder.addAttributeProvider((IAttributeEncoder)new SignaturePolicyIdentifierEncoder(signaturePolicy));
        }
        if ((commitmentTypeIndication = AdESSignerTools.getCommitmentTypeIndication((IArgs)args)) != null) {
            builder.addAttributeProvider((IAttributeEncoder)new CommitmentTypeIndicationEncoder(ListTools.with((Object[])new ICommitmentTypeIndication[]{commitmentTypeIndication})));
        }
        if (!(attrCerts = AdESSignerTools.getAttributeCertificates((IArgs)args)).isEmpty()) {
            builder.addAttributeProvider((IAttributeEncoder)new SignerAttributesV2Encoder((Collection)attrCerts));
        }
        if ((level = SignatureCreationService.getConformanceLevel((IArgs)args, null)) == null || level.isTimestampRequired()) {
            boolean enforceTimestamp;
            ITimestampCreator tsService = AdESSignerTools.createTimestampCreator((IArgs)args);
            boolean bl = enforceTimestamp = level != null && level.isTimestampRequired();
            if (enforceTimestamp && tsService == null) {
                tsService = AdESEnvironment.get().createDefaultTimestampCreator();
            }
            TimestampEncoder timestampEncoder = new TimestampEncoder(tsService);
            timestampEncoder.setEnforceTimestamp(enforceTimestamp);
            builder.addAttributeProvider((IAttributeEncoder)timestampEncoder);
        }
        ISigner digestSigner = builder.getSigner();
        ValidationDataOptions options = AdESSignerTools.getValidationDataOptions((IArgs)args);
        if (options.isAddValidationData()) {
            ResultValidationDataAppender appender = new ResultValidationDataAppender();
            appender.setValidationDataOptions(options);
            appender.setFailOnError(false);
            appender.setValidationDataCollector(() -> (IValidationDataCollector)AdapterTools.getAdapter((Object)digestSigner, IValidationDataCollector.class, null));
            builder.addPostProcessor((ISignatureContainerEntryProcessor)appender);
        }
        if (signaturePolicy != null) {
            IReviewer policyValidator = SignaturePolicyValidator.create((IPolicyReference)signaturePolicy);
            builder.addPostProcessor((ISignatureContainerEntryProcessor)new SignatureContainerEntryReviewer(policyValidator));
        }
    }

    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        super.prepareDigestSigner(signer, args);
        signer.setSignatureFormat(SignatureFormat.PAdES);
    }
}

