/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.validation;

import de.intarsys.security.app.validation.ICRLService;
import de.intarsys.security.app.validation.ICertificatePathBuilder;
import de.intarsys.security.app.validation.IOCSPService;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationDataCollector;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509CertificatePath;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.common.X509CertificatePath;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.cms.validation.PACKAGE;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.standard.validation.ExtendedValidationData;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.security.validation.IVSCRL;
import de.intarsys.security.validation.IVSCRLRequest;
import de.intarsys.security.validation.IVSCertificatePath;
import de.intarsys.security.validation.IVSOCSP;
import de.intarsys.security.validation.IVSOCSPRequest;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ValidationDataCollector
implements IValidationDataCollector {
    private static final Logger Log = LoggerFactory.getLogger(ValidationDataCollector.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ValidationDataOptions validationDataOptions = ValidationDataOptions.SIGNER;
    private boolean failOnError = false;
    private long maxSize = -1L;
    private List<Object> revocationInfo;

    protected ValidationDataCollector() {
    }

    public IExtendedValidationData collect() throws IOException {
        HashMap<IX509Certificate, Object> result = new HashMap<IX509Certificate, Object>();
        Args contextArgs = Args.create();
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)contextArgs);
        ArrayList<IX509Certificate> allCerts = new ArrayList<IX509Certificate>();
        allCerts.addAll(Arrays.asList(this.getSignerCertificates()));
        allCerts.addAll(Arrays.asList(this.getAttributeCertificates()));
        for (IX509Certificate cert : allCerts) {
            this.collectRevocationInfo(cert, context, result);
        }
        HashSet revocationInfo = new HashSet();
        for (Object value : result.values()) {
            if (value == null) continue;
            revocationInfo.add(value);
        }
        this.setRevocationInfo(new ArrayList<Object>(revocationInfo));
        return this.createExtendedValidationData();
    }

    protected void collectRevocationInfo(IX509Certificate cert, IValidationContext context, Map<IX509Certificate, Object> result) throws IOException {
        IX509CertificatePath certificatePath = this.getCertificatePath(cert);
        ArrayList<IX509Certificate> currentPathElements = new ArrayList<IX509Certificate>();
        int startIndex = 1;
        if (!this.getValidationDataOptions().isAddRevocationInfoDepthAll()) {
            startIndex = certificatePath.size();
        }
        for (int i = 1; i <= certificatePath.size(); ++i) {
            IX509Certificate certificate = certificatePath.getCertificate(i);
            currentPathElements.add(certificate);
            if (i < startIndex || !this.requiresRevocationCheck(certificate)) continue;
            X509CertificatePath currentPath = new X509CertificatePath(currentPathElements);
            this.collectRevocationInfo((IX509CertificatePath)currentPath, context, result);
        }
    }

    protected void collectRevocationInfo(IX509CertificatePath certificatePath, IValidationContext context, Map<IX509Certificate, Object> result) throws IOException {
        IX509Certificate leafCertificate = certificatePath.getLeafCertificate();
        if (result.containsKey(leafCertificate)) {
            return;
        }
        result.put(leafCertificate, null);
        if (this.getValidationDataOptions().isAddRevocationInfoTypeOcsp()) {
            IOCSPService ocspService = context.getOCSPService();
            try {
                IX509Certificate ocspSignerCert;
                ValidationParameters parameters = new ValidationParameters();
                IVSOCSP ocspState = ocspService.validateCertificate(leafCertificate, certificatePath, (IValidationParameters)parameters);
                IVSOCSPRequest requestState = this.getBestOCSPRequestState(ocspState);
                result.put(leafCertificate, requestState.getResponse());
                if (this.getValidationDataOptions().isAddRevocationInfoDepthAll() && (ocspSignerCert = requestState.getCertificateState().getX509Certificate()) != null) {
                    this.collectRevocationInfo(ocspSignerCert, context, result);
                }
                return;
            }
            catch (IOException e) {
                Log.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (this.getValidationDataOptions().isAddRevocationInfoTypeCrl()) {
            ICRLService crlService = context.getCRLService();
            try {
                IX509Certificate crlSignerCert;
                ValidationParameters parameters = new ValidationParameters();
                parameters.setCRLProvider(ValidationEnvironment.get().getCRLProvider());
                IVSCRL crlState = crlService.validateCertificate(certificatePath.getLeafCertificate(), certificatePath, (IValidationParameters)parameters);
                IVSCRLRequest crlRequestState = this.getBestCRLRequestState(crlState);
                result.put(leafCertificate, crlRequestState.getCRL());
                if (this.getValidationDataOptions().isAddRevocationInfoDepthAll() && (crlSignerCert = crlRequestState.getCertificateState().getX509Certificate()) != null) {
                    this.collectRevocationInfo(crlSignerCert, context, result);
                }
                return;
            }
            catch (IOException e) {
                Log.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (this.isFailOnError()) {
            throw new IOException("revocation info unavailable");
        }
    }

    protected IExtendedValidationData createExtendedValidationData() {
        List<IX509CRL> crls = this.getCRLs();
        List<IOCSPResponse> ocsps = this.getOCSPs();
        return new ExtendedValidationData(crls.toArray(new IX509CRL[crls.size()]), ocsps.toArray(new IOCSPResponse[ocsps.size()]), new IX509PublicKeyCertificate[0]);
    }

    protected abstract List<IX509Certificate> getAdditionalCertificates() throws IOException;

    protected abstract IX509Certificate[] getAttributeCertificates() throws IOException;

    protected IVSCRLRequest getBestCRLRequestState(IVSCRL crlState) throws IOException {
        if (crlState == null || crlState.isUndefined()) {
            String msg = Msg.getString("ValidationDataCollector.ErrorNoCRLAvailable", new Object[0]);
            throw new IOException(msg);
        }
        IVSCRLRequest fallbackCRL = null;
        List requestStates = crlState.getRequestStates();
        for (IVSCRLRequest requestState : requestStates) {
            if (requestState.isValid()) {
                if (requestState.getCRL() == null) continue;
                return requestState;
            }
            if (fallbackCRL != null) continue;
            fallbackCRL = requestState;
        }
        if (fallbackCRL != null) {
            return fallbackCRL;
        }
        String msg = Msg.getString("ValidationDataCollector.ErrorNoCRLAvailable", new Object[0]);
        throw new IOException(msg);
    }

    protected IVSOCSPRequest getBestOCSPRequestState(IVSOCSP ocspState) throws IOException {
        if (ocspState == null || ocspState.isUndefined()) {
            String msg = Msg.getString("ValidationDataCollector.ErrorOCSPRequestNotMade", new Object[0]);
            throw new IOException(msg);
        }
        IVSOCSPRequest fallbackRequestState = null;
        List requestStates = ocspState.getRequestStates();
        for (IVSOCSPRequest requestState : requestStates) {
            if (requestState.isValid()) {
                if (requestState.getResponse() == null) continue;
                return requestState;
            }
            if (fallbackRequestState != null) continue;
            fallbackRequestState = requestState;
        }
        if (fallbackRequestState != null) {
            return fallbackRequestState;
        }
        String msg = Msg.getString("ValidationDataCollector.ErrorOCSPRequestNotMade", new Object[0]);
        throw new IOException(msg);
    }

    protected IX509CertificatePath getCertificatePath(IX509Certificate certificate) throws IOException {
        Args args = Args.create();
        args.put("stopOnIntermediateTrustAnchor", (Object)false);
        args.put("checkCRL", (Object)false);
        args.put("checkOCSP", (Object)false);
        IValidationContext validationContext = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)args);
        ICertificatePathBuilder pathBuilder = validationContext.getCertificatePathBuilder();
        ValidationParameters parameters = new ValidationParameters();
        parameters.setAdditionalCerts(this.getAdditionalCertificates());
        IVSCertificatePath state = pathBuilder.buildCertificatePath(certificate, (IValidationParameters)parameters);
        if (state == null || state.getCertPath() == null) {
            return new X509CertificatePath(ListTools.with((Object[])new IX509Certificate[]{certificate}));
        }
        return state.getCertPath();
    }

    protected List<IX509CRL> getCRLs() {
        ArrayList<IX509CRL> crls = new ArrayList<IX509CRL>();
        for (Object revInfo : this.getRevocationInfo()) {
            if (!(revInfo instanceof IX509CRL)) continue;
            crls.add((IX509CRL)revInfo);
        }
        return crls;
    }

    protected IVSCRL getCRLValidatorResult(IX509CertificatePath certificatePath) {
        Args contextArgs = Args.create();
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)contextArgs);
        ICRLService crlService = context.getCRLService();
        ValidationParameters parameters = new ValidationParameters();
        IVSCRL crlState = crlService.validateCertificate(certificatePath.getLeafCertificate(), certificatePath, (IValidationParameters)parameters);
        return crlState;
    }

    public long getMaxSize() {
        return this.maxSize;
    }

    protected List<IOCSPResponse> getOCSPs() {
        ArrayList<IOCSPResponse> ocsps = new ArrayList<IOCSPResponse>();
        for (Object revInfo : this.getRevocationInfo()) {
            if (!(revInfo instanceof IOCSPResponse)) continue;
            ocsps.add((IOCSPResponse)revInfo);
        }
        return ocsps;
    }

    protected IVSOCSP getOCSPValidatorResult(IX509CertificatePath certificatePath) {
        Args contextArgs = Args.create();
        IValidationContext context = ValidationEnvironment.get().getValidationContextFactory().createValidationContext((IArgs)contextArgs);
        IOCSPService ocspService = context.getOCSPService();
        ValidationParameters parameters = new ValidationParameters();
        IVSOCSP ocspState = ocspService.validateCertificate(certificatePath.getLeafCertificate(), certificatePath, (IValidationParameters)parameters);
        return ocspState;
    }

    public List<Object> getRevocationInfo() {
        return this.revocationInfo;
    }

    protected abstract IX509Certificate[] getSignerCertificates() throws IOException;

    public ValidationDataOptions getValidationDataOptions() {
        return this.validationDataOptions;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    protected boolean requiresRevocationCheck(IX509Certificate certificate) {
        if (CertificateTools.isSelfSigned((IX509Certificate)certificate)) {
            return false;
        }
        byte[] noCheck = certificate.getExtensionValue("1.3.6.1.5.5.7.48.1.5");
        return noCheck == null;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    public void setRevocationInfo(List<Object> revocationInfo) {
        this.revocationInfo = revocationInfo;
    }

    public void setValidationDataOptions(ValidationDataOptions validationDataOptions) {
        this.validationDataOptions = validationDataOptions;
    }
}

