/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.signature;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.CertificateSet;
import de.intarsys.asn1.cms.ContentInfo;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.DigestAlgorithmIdentifiers;
import de.intarsys.asn1.cms.EncapsulatedContentInfo;
import de.intarsys.asn1.cms.SignatureValue;
import de.intarsys.asn1.cms.SignedAttributes;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.asn1.cms.SignerIdentifier;
import de.intarsys.asn1.cms.SignerInfo;
import de.intarsys.asn1.cms.SignerInfos;
import de.intarsys.asn1.cms.UnsignedAttributes;
import de.intarsys.asn1.common.AlgorithmIdentifier;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.common.RSASSAPSSParams;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.x509.Certificate;
import de.intarsys.asn1.x509.CommonCertificate;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.cms.attribute.encoder.ContentTypeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.IAttributeEncoder;
import de.intarsys.security.method.cms.attribute.encoder.MessageDigestEncoder;
import de.intarsys.security.method.cms.signature.CMSSignatureContainer;
import de.intarsys.security.method.cms.signature.CMSSignatureEntry;
import de.intarsys.security.method.cms.signature.ICMSSignatureContainerBuilder;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.oid.OIDTools;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.signature.common.IToBeSignedData;
import de.intarsys.security.signature.common.ToBeSignedData;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.tag.Tag;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSSignatureContainerBuilder
implements ICMSSignatureContainerBuilder {
    private static final Logger Log = LoggerFactory.getLogger(CMSSignatureContainerBuilder.class);
    private ISigner signer;
    private List<IAttributeEncoder> signedAttributeProviders;
    private List<IAttributeEncoder> unsignedAttributeProviders;
    private boolean includeCertificates = true;
    private final List<ISignatureContainerEntryProcessor> postProcessors = new ArrayList<ISignatureContainerEntryProcessor>();
    private IDigest digest;
    private ILocator content;
    private String contentType;

    public static IDigest getDigest(IArgs args) throws IOException {
        return DigestTools.createDigest((Object)args.get("hash"));
    }

    public static IFactory<ICMSSignatureContainerBuilder> getFactory(IArgs args, Object defaultValue) throws ObjectCreationException {
        Object format = args.get("format", defaultValue);
        return CMSSignatureContainerBuilder.getFactory(format);
    }

    public static IFactory<ICMSSignatureContainerBuilder> getFactory(Object format) throws ObjectCreationException {
        if (format instanceof IFactory) {
            return (IFactory)format;
        }
        try {
            String formatId = (String)ConverterRegistry.get().convert(format, String.class);
            IFactory factory = FactoryTools.lookupFactoryFor(ICMSSignatureContainerBuilder.class, (List)ListTools.with((Object[])new Tag[]{new Tag("format", formatId)}));
            if (factory == null && (factory = FactoryTools.lookupFactory((String)formatId, null)) == null) {
                throw new ObjectCreationException("Invalid PKCS7 signature format: " + formatId);
            }
            return factory;
        }
        catch (ConversionException e) {
            throw new ObjectCreationException((Throwable)e);
        }
    }

    @Override
    public void addAttributeProvider(IAttributeEncoder attrProvider) {
        if (attrProvider.isToBeSigned()) {
            this.addSignedAttributeProvider(attrProvider);
        } else {
            this.addUnsignedAttributeProvider(attrProvider);
        }
    }

    @Override
    public void addPostProcessor(ISignatureContainerEntryProcessor processor) {
        this.postProcessors.add(processor);
    }

    private void addSignedAttributeProvider(IAttributeEncoder attrProvider) {
        if (this.signedAttributeProviders == null) {
            this.signedAttributeProviders = new ArrayList<IAttributeEncoder>();
        }
        this.signedAttributeProviders.add(attrProvider);
    }

    private void addUnsignedAttributeProvider(IAttributeEncoder attrProvider) {
        if (this.unsignedAttributeProviders == null) {
            this.unsignedAttributeProviders = new ArrayList<IAttributeEncoder>();
        }
        this.unsignedAttributeProviders.add(attrProvider);
    }

    private void addUnsignedAttributes(CMSSigningResult signingResult, IDigest documentDigest) throws IOException {
        if (this.getUnsignedAttributeProviders() == null) {
            return;
        }
        SignerInfos signerInfos = signingResult.getCms().getSignedData().getSignerInfos();
        for (int i = 0; i < signerInfos.size(); ++i) {
            SignerInfo signerInfo = signerInfos.get(i);
            UnsignedAttributes unsignedAttrs = signerInfo.getUnsignedAttrs();
            if (unsignedAttrs == null) {
                unsignedAttrs = (UnsignedAttributes)UnsignedAttributes.FACTORY.createNew();
                signerInfo.setUnsignedAttrs(unsignedAttrs);
            }
            for (IAttributeEncoder provider : this.getUnsignedAttributeProviders()) {
                Attribute attr = provider.getAttribute(this, signingResult.getCms(), signerInfo, signingResult.getSignatureData());
                if (attr == null) continue;
                unsignedAttrs.add(attr);
            }
        }
    }

    protected IConversation<CMSSigningResult> basicSign(IDigest documentDigest, String contentTypeId) {
        if (this.getSigner().isBasic()) {
            return this.basicSignPkcs1Based(documentDigest, contentTypeId);
        }
        return this.basicSignPkcs7Based(documentDigest);
    }

    protected IConversation<CMSSigningResult> basicSignPkcs1Based(IDigest documentDigest, String contentTypeId) {
        try {
            IDigest digest;
            IX509PublicKeyCertificate[] certs = this.getSigner().getCertificatePath();
            if (certs == null || certs.length == 0) {
                return Conversation.failed((Throwable)new IllegalArgumentException("signer must provide at least the signer certificate"));
            }
            Certificate signerCert = this.recodeCertificate(certs[0]);
            CMS cms = (CMS)CMS.FACTORY.createNew();
            SignedData signedData = (SignedData)SignedData.FACTORY.createNew();
            cms.setSignedData(signedData);
            DigestAlgorithmIdentifiers digestAlgorithms = (DigestAlgorithmIdentifiers)DigestAlgorithmIdentifiers.FACTORY.createNew();
            signedData.setDigestAlgorithms(digestAlgorithms);
            String documentDigestOid = DigestAlgorithm.lookupOID((String)documentDigest.getAlgorithmName());
            AlgorithmIdentifier digestAlgorithm = AlgorithmIdentifier.create((String)documentDigestOid);
            digestAlgorithms.add(digestAlgorithm);
            EncapsulatedContentInfo encapContentInfo = (EncapsulatedContentInfo)EncapsulatedContentInfo.FACTORY.createNew();
            signedData.setEncapContentInfo((ContentInfo)encapContentInfo);
            if (contentTypeId == null) {
                encapContentInfo.setContentTypeData();
            } else {
                ContentType contentType = (ContentType)ContentType.FACTORY.createNew();
                contentType.setIdentifier(contentTypeId);
                encapContentInfo.setContentType(contentType);
            }
            if (this.isIncludeCertificates()) {
                CertificateSet certificates = (CertificateSet)CertificateSet.FACTORY.createNew();
                signedData.setCertificates(certificates);
                certificates.add((CommonCertificate)signerCert);
                ArrayList<Certificate> additionalCerts = new ArrayList<Certificate>(certs.length - 1);
                for (int i = 1; i < certs.length; ++i) {
                    try {
                        additionalCerts.add(this.recodeCertificate(certs[i]));
                        continue;
                    }
                    catch (IOException e) {
                        Log.warn(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                certificates.addAll(additionalCerts);
            }
            SignerInfos signerInfos = (SignerInfos)SignerInfos.FACTORY.createNew();
            signedData.setSignerInfos(signerInfos);
            SignerInfo signerInfo = (SignerInfo)SignerInfo.FACTORY.createNew();
            signerInfos.add(signerInfo);
            SignerIdentifier signerId = (SignerIdentifier)SignerIdentifier.FACTORY.createNew();
            signerId.setIssuerAndSerialNumber(signerCert.getIssuerAndSerialNumber());
            signerInfo.setSid(signerId);
            signerInfo.setDigestAlgorithm(digestAlgorithm);
            IDigester digester = DigestTools.createDigester((String)documentDigest.getAlgorithmName());
            if (this.useSignedAttributes()) {
                SignedAttributes signedAttrs = (SignedAttributes)SignedAttributes.FACTORY.createNew();
                signerInfo.setSignedAttrs(signedAttrs);
                this.addAttributeProvider(new MessageDigestEncoder());
                this.addAttributeProvider(new ContentTypeEncoder());
                for (IAttributeEncoder attrProvider : this.getSignedAttributeProviders()) {
                    Attribute attr = attrProvider.getAttribute(this, cms, signerInfo, null);
                    if (attr == null) continue;
                    signedAttrs.add(attr);
                }
                byte[] encodedSignedAttrs = signedAttrs.derSetEncoded();
                digest = digester.digest(encodedSignedAttrs);
            } else {
                digest = documentDigest;
            }
            IConversation signerConversation = this.getSigner().sign((IToBeSignedData)ToBeSignedData.create((IDigest)digest));
            return signerConversation.thenApply(signature -> {
                signerInfo.setSignature(SignatureValue.create((byte[])signature.getEncodedSignature()));
                AlgorithmIdentifier signatureAlgorithm = this.deriveSignatureAlgorithm(digest);
                signerInfo.setSignatureAlgorithm(signatureAlgorithm);
                signerInfo.setVersionAccordingToContent();
                signedData.setVersionAccordingToContent();
                return new CMSSigningResult(cms, (ISignatureData)signature);
            });
        }
        catch (NoSuchAlgorithmException e) {
            return Conversation.failed((Throwable)new SecurityApplicationException("No such algorithm: " + documentDigest.getAlgorithmName(), (Throwable)e));
        }
        catch (Exception e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected IConversation<CMSSigningResult> basicSignPkcs7Based(IDigest documentDigest) {
        if (this.getSignedAttributeProviders() != null) {
            Log.debug("provided signer doesn't support signed attributes, attribute configuration will be ignored");
        }
        try {
            IConversation signerConversation = this.getSigner().sign((IToBeSignedData)ToBeSignedData.create((IDigest)documentDigest));
            return signerConversation.thenApply(signature -> {
                CMS cms = (CMS)ASN1BasedTools.create((ASN1Based.Factory)CMS.FACTORY, (byte[])signature.getEncodedSignature());
                return new CMSSigningResult(cms, (ISignatureData)signature);
            });
        }
        catch (IOException e) {
            return Conversation.failed((Throwable)e);
        }
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithm(IDigest digest) throws SecurityApplicationException {
        AlgorithmParameterSpec encAlgParams = this.getSigner().getAlgorithmParameterSpec();
        if (encAlgParams instanceof PSSParameterSpec) {
            return this.deriveSignatureAlgorithmPSS(digest, (PSSParameterSpec)encAlgParams);
        }
        return this.deriveSignatureAlgorithmDefault(digest);
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithmDefault(IDigest digest) throws SecurityApplicationException {
        String digestAlgorithmName;
        String encryptionAlgorithmName = this.getSigner().getEncryptionAlgorithmName();
        String signatureAlgorithmOid = SignatureAlgorithm.createOID((String)encryptionAlgorithmName, (String)(digestAlgorithmName = digest.getAlgorithmName()), null);
        if (signatureAlgorithmOid == null) {
            throw new SecurityApplicationException(String.format("No signature algorithm for %s with %s supported", encryptionAlgorithmName, digestAlgorithmName));
        }
        return AlgorithmIdentifier.create((String)signatureAlgorithmOid);
    }

    protected AlgorithmIdentifier deriveSignatureAlgorithmPSS(IDigest digest, PSSParameterSpec pssParams) throws SecurityApplicationException {
        AlgorithmIdentifier signatureAlgorithm = AlgorithmIdentifier.create((String)"1.2.840.113549.1.1.10");
        RSASSAPSSParams signatureAlgorithmParameters = (RSASSAPSSParams)RSASSAPSSParams.FACTORY.createNew();
        String hashAlgorithmOid = DigestAlgorithm.lookupOID((String)pssParams.getDigestAlgorithm());
        signatureAlgorithmParameters.setHashAlgorithm(AlgorithmIdentifier.create((String)hashAlgorithmOid));
        String mgfName = pssParams.getMGFAlgorithm();
        String mgfOid = OIDTools.getMaskGenerationAlgorithmOID((String)mgfName);
        if (mgfOid == null) {
            throw new SecurityApplicationException("unsupported mask generation function: " + mgfName);
        }
        AlgorithmIdentifier mgfAlgorithm = AlgorithmIdentifier.create((String)mgfOid);
        switch (mgfOid) {
            case "1.2.840.113549.1.1.8": {
                MGF1ParameterSpec mgfParameters = (MGF1ParameterSpec)pssParams.getMGFParameters();
                String mfgHashAlgorithmOid = DigestAlgorithm.lookupOID((String)mgfParameters.getDigestAlgorithm());
                mgfAlgorithm.setParameters((ASN1Encodable)AlgorithmIdentifier.create((String)mfgHashAlgorithmOid));
            }
        }
        signatureAlgorithmParameters.setMaskGenAlgorithm(mgfAlgorithm);
        signatureAlgorithmParameters.setSaltLength(pssParams.getSaltLength());
        signatureAlgorithmParameters.setTrailerField(pssParams.getTrailerField());
        signatureAlgorithm.setParameters((ASN1Encodable)signatureAlgorithmParameters);
        return signatureAlgorithm;
    }

    public List<IAttributeEncoder> getAttributeProviders() {
        ArrayList<IAttributeEncoder> all = new ArrayList<IAttributeEncoder>();
        if (this.getSignedAttributeProviders() != null) {
            all.addAll(this.getSignedAttributeProviders());
        }
        if (this.getUnsignedAttributeProviders() != null) {
            all.addAll(this.getUnsignedAttributeProviders());
        }
        return all;
    }

    public ILocator getContent() {
        return this.content;
    }

    public String getContentType() {
        return this.contentType;
    }

    @Override
    public IDigest getDigest() {
        return this.digest;
    }

    protected CMSSignatureEntry getFirstSignatureEntry(CMSSignatureContainer signatureContainer) {
        Iterator<CMSSignatureEntry> iterator = signatureContainer.getEntries().iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public List<ISignatureContainerEntryProcessor> getPostProcessors() {
        return new ArrayList<ISignatureContainerEntryProcessor>(this.postProcessors);
    }

    private List<IAttributeEncoder> getSignedAttributeProviders() {
        return this.signedAttributeProviders;
    }

    @Override
    public ISigner getSigner() {
        return this.signer;
    }

    private List<IAttributeEncoder> getUnsignedAttributeProviders() {
        return this.unsignedAttributeProviders;
    }

    public boolean isIncludeCertificates() {
        return this.includeCertificates;
    }

    protected void postProcess(CMSSignatureContainer signatureContainer, CMSSigningResult signingResult) throws SecurityApplicationException, IOException {
        List<CMSSignatureEntry> entries = signatureContainer.getEntries();
        int count = entries.size();
        if (count == 0) {
            return;
        }
        CMSSignatureEntry entry = entries.get(count - 1);
        this.postProcess((ISignatureContainerEntry)entry, signingResult);
    }

    protected void postProcess(ISignatureContainerEntry signature, CMSSigningResult signingResult) throws SecurityApplicationException, IOException {
        for (ISignatureContainerEntryProcessor processor : this.getPostProcessors()) {
            processor.process((ISignatureContainerBuilder)this, signature, signingResult.getSignatureData());
        }
    }

    private Certificate recodeCertificate(IX509PublicKeyCertificate cert) throws IOException {
        try {
            return (Certificate)ASN1BasedTools.create((ASN1Based.Factory)Certificate.FACTORY, (byte[])cert.getEncoded());
        }
        catch (CertificateEncodingException e) {
            String msg = "Failed recoding certificate (" + cert.getSubjectX500Principal().toString() + "):" + e.getLocalizedMessage();
            throw new IOException(msg, e);
        }
    }

    @Override
    public void removeAttributeProvider(IAttributeEncoder attrProvider) {
        if (attrProvider.isToBeSigned()) {
            this.removeSignedAttributeProvider(attrProvider);
        } else {
            this.removeUnsignedAttributeProvider(attrProvider);
        }
    }

    private void removeSignedAttributeProvider(IAttributeEncoder attrProvider) {
        if (this.signedAttributeProviders == null) {
            return;
        }
        this.signedAttributeProviders.remove(attrProvider);
    }

    private void removeUnsignedAttributeProvider(IAttributeEncoder attrProvider) {
        if (this.unsignedAttributeProviders == null) {
            return;
        }
        this.unsignedAttributeProviders.remove(attrProvider);
    }

    @Override
    public IConversation<CMSSignatureContainer> run() {
        IConversation<CMSSigningResult> cmsConversation = this.basicSign(this.getDigest(), this.getContentType());
        return cmsConversation.thenApply(result -> {
            if (this.getContent() != null) {
                SignedData signedData = result.getCms().getSignedData();
                EncapsulatedContentInfo contentInfo = signedData.getEncapContentInfo();
                contentInfo.setContent(LocatorTools.getBytes((ILocator)this.getContent()));
            }
            CMSSignatureContainer pkcs7 = new CMSSignatureContainer(result.getCms());
            this.addUnsignedAttributes((CMSSigningResult)result, this.getDigest());
            this.postProcess(pkcs7, (CMSSigningResult)result);
            return pkcs7;
        });
    }

    public void setContent(ILocator content) {
        this.content = content;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setDigest(IDigest digest) {
        this.digest = digest;
    }

    @Override
    public void setIncludeCertificates(boolean includeCertificates) {
        this.includeCertificates = includeCertificates;
    }

    public void setSigner(ISigner signer) {
        this.signer = signer;
    }

    protected boolean useSignedAttributes() {
        return this.getSignedAttributeProviders() != null && !this.getSignedAttributeProviders().isEmpty();
    }

    private static class CMSSigningResult {
        private final CMS cms;
        private final ISignatureData signatureData;

        public CMSSigningResult(CMS cms, ISignatureData signatureData) {
            this.cms = cms;
            this.signatureData = signatureData;
        }

        public CMS getCms() {
            return this.cms;
        }

        public ISignatureData getSignatureData() {
            return this.signatureData;
        }
    }
}

