/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.decryption;

import de.intarsys.asn1.cms.CMS;
import de.intarsys.asn1.cms.ContentEncryptionAlgorithmIdentifier;
import de.intarsys.asn1.cms.EncryptedContentInfo;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.RecipientInfo;
import de.intarsys.asn1.cms.RecipientInfos;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.KeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricCryptHandlerRegistry;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricDecryptorException;
import de.intarsys.security.app.decryption.IDecryptor;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.method.cms.decryption.CommonPKCS7Decoder;
import de.intarsys.security.method.cms.decryption.PKCS7DecryptionTools;
import de.intarsys.security.method.cms.decryption.PKCS7RecipientInfoDecoder;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7EnvelopedDataDecoder
extends CommonPKCS7Decoder {
    private static final Logger Log = LoggerFactory.getLogger(PKCS7EnvelopedDataDecoder.class);
    private IDecryptor decryptor;

    protected byte[] basicDecrypt(EncryptedContentInfo encryptedContentInfo, byte[] key) throws SecurityApplicationException {
        byte[] encryptionAlgorithmParameters;
        byte[] encryptedData = encryptedContentInfo.getEncryptedContent().getBytes();
        ContentEncryptionAlgorithmIdentifier encryptionAlgorithmIdentifier = encryptedContentInfo.getContentEncryptionAlgorithmIdentifier();
        String encryptionAlgorithm = encryptionAlgorithmIdentifier.getAlgorithm();
        try {
            encryptionAlgorithmParameters = encryptionAlgorithmIdentifier.getParametersEncoded();
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        ISymmetricCryptHandler decryptor = this.lookupDataDecryptor(encryptionAlgorithm);
        if (decryptor == null) {
            throw new SecurityApplicationException("Unknown data encryption algorithm: " + encryptionAlgorithm);
        }
        try {
            ByteArrayLocator encryptedDataLocator = new ByteArrayLocator(encryptedData, "temp", "unknown");
            return decryptor.decrypt((IKeyEncryptedData)new KeyEncryptedData((ILocator)encryptedDataLocator, encryptionAlgorithm, key, encryptionAlgorithmParameters));
        }
        catch (SymmetricDecryptorException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
    }

    protected byte[] decryptKey(RecipientInfos recipientInfos) throws SecurityApplicationException {
        IX509Certificate certificate = this.getDecryptor().getCertificate();
        if (certificate == null) {
            throw new SecurityApplicationException("certificate missing");
        }
        for (int i = 0; i < recipientInfos.size(); ++i) {
            IX509CertificateFilter selector;
            RecipientInfo recipientInfo = recipientInfos.get(i);
            try {
                selector = PKCS7DecryptionTools.createCertificateSelector(recipientInfo);
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
                continue;
            }
            if (!selector.accept(certificate)) continue;
            try {
                PKCS7RecipientInfoDecoder recipientInfoDecoder = new PKCS7RecipientInfoDecoder();
                byte[] decryptedKey = recipientInfoDecoder.decode(recipientInfo, this.getDecryptor());
                return decryptedKey;
            }
            catch (Exception e) {
                throw (SecurityApplicationException)ExceptionTools.createTypedFromChain((Throwable)e, SecurityApplicationException.class);
            }
        }
        throw new SecurityApplicationException("no matching certificate provided");
    }

    public IDecryptor getDecryptor() {
        return this.decryptor;
    }

    protected ISymmetricCryptHandler lookupDataDecryptor(String algorithmOid) {
        return SymmetricCryptHandlerRegistry.get().lookupHandler(algorithmOid);
    }

    @Override
    protected void process(CMS cms, ILocator destination) throws SecurityApplicationException {
        EnvelopedData envelopedData = cms.getEnvelopedData();
        byte[] key = this.decryptKey(envelopedData.getRecipientInfos());
        byte[] data = this.basicDecrypt(envelopedData.getEncryptedContentInfo(), key);
        OutputStream os = null;
        try {
            os = destination.getOutputStream();
            os.write(data);
        }
        catch (IOException e) {
            throw new SecurityApplicationException((Throwable)e);
        }
        finally {
            StreamTools.close((Closeable)os);
        }
    }

    public void setDecryptor(IDecryptor device) {
        this.decryptor = device;
    }
}

