/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.cms.attribute.decoder;

import de.intarsys.asn1.cms.attr.AttributeSignerAttributesV2;
import de.intarsys.asn1.cms.attr.CertifiedAttributesV2;
import de.intarsys.asn1.cms.attr.ClaimedAttributes;
import de.intarsys.asn1.cms.attr.SignerAttributeV2;
import de.intarsys.asn1.common.Attribute;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.attribute.X509AttributeFactory;
import de.intarsys.security.certificate.attribute.X509V1AttributeCertificate;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.ISignerAttributesV2Attribute;
import de.intarsys.security.signature.attribute.impl.SignerAttributesV2Attribute;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Encodable;

public class SignerAttributesV2Decoder
implements IAttributeDecoder {
    public ISignerAttributesV2Attribute decodeAttribute(Object srcAttribute) throws IOException {
        Attribute cmsAttribute = (Attribute)srcAttribute;
        AttributeSignerAttributesV2 attrSignerAttributes = (AttributeSignerAttributesV2)AttributeSignerAttributesV2.FACTORY.create((ASN1Encodable)cmsAttribute);
        if (attrSignerAttributes == null || attrSignerAttributes.getSignerAttribute() == null) {
            return null;
        }
        SignerAttributeV2 signerAttribute = attrSignerAttributes.getSignerAttribute();
        IX509AttributeCertificate[] attributeCertificates = this.getAttributeCertificates(signerAttribute);
        IX509Attribute[] claimedAttributes = this.getClaimedAttributes(signerAttribute);
        return new SignerAttributesV2Attribute(attributeCertificates, claimedAttributes);
    }

    private IX509AttributeCertificate[] getAttributeCertificates(SignerAttributeV2 signerAttribute) throws IOException {
        ArrayList<X509V1AttributeCertificate> result = new ArrayList<X509V1AttributeCertificate>();
        if (signerAttribute.hasCertifiedAttributes()) {
            CertifiedAttributesV2 certifiedAttributes = signerAttribute.getCertifiedAttributes();
            for (AttributeCertificate attributeCertificate : certifiedAttributes.getAttributeCertificates()) {
                try {
                    result.add(new X509V1AttributeCertificate(attributeCertificate));
                }
                catch (CertificateException e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
        }
        return result.toArray(new IX509AttributeCertificate[result.size()]);
    }

    private IX509Attribute[] getClaimedAttributes(SignerAttributeV2 signerAttribute) throws IOException {
        ArrayList<IX509Attribute> result = new ArrayList<IX509Attribute>();
        if (signerAttribute.hasClaimedAttributes()) {
            ClaimedAttributes claimedAttributes = signerAttribute.getClaimedAttributes();
            for (Attribute attribute : claimedAttributes.getAll()) {
                IX509Attribute x509Attribute = X509AttributeFactory.get().create(attribute);
                result.add(x509Attribute);
            }
        }
        return result.toArray(new IX509Attribute[result.size()]);
    }

    public String getOID() {
        return "0.4.0.19122.1.1";
    }
}

