/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.intarsys.tools.jackson.DtoTypedObject;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;

public class TypedDeserializer
extends StdDeserializer<Object> {
    protected TypedDeserializer() {
        super(Object.class);
    }

    public Object deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.START_OBJECT) {
            Class<Object> clazz;
            Object result = null;
            parser.nextToken();
            String name = parser.getText();
            if ("@class".equals(name)) {
                parser.nextToken();
                String classname = parser.getText();
                try {
                    clazz = ClassTools.createClass((String)classname, Object.class, null);
                }
                catch (ObjectCreationException e) {
                    result = new DtoTypedObject(classname, null);
                    clazz = Object.class;
                }
            } else {
                throw new IOException("@class required as first element");
            }
            parser.nextToken();
            name = parser.getText();
            if ("value".equals(name)) {
                parser.nextToken();
                Object value = ctxt.readValue(parser, clazz);
                if (result == null) {
                    result = value;
                } else {
                    ((DtoTypedObject)result).setValueBasic(value);
                }
            } else {
                throw new IOException("unknown token " + name);
            }
            token = parser.nextToken();
            if (token != JsonToken.END_OBJECT) {
                throw new IOException("unsupported token " + token);
            }
            return result;
        }
        throw new IOException("unsupported token " + token);
    }
}

