/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.validation;

import de.intarsys.tools.validation.CommonValidator;
import de.intarsys.tools.validation.IValidationResult;
import de.intarsys.tools.validation.IValidator;
import de.intarsys.tools.validation.ValidationResult;
import java.util.ArrayList;
import java.util.List;

public class CompositeValidator<T>
extends CommonValidator<T> {
    private final List<IValidator<T>> validators = new ArrayList<IValidator<T>>();

    public void addValidator(IValidator<T> validator) {
        this.validators.add(validator);
    }

    @Override
    protected void basicValidate(ValidationResult result, T target) {
        for (IValidator<T> validator : this.validators) {
            IValidationResult tempResult = validator.validate(target);
            result.addNotices(tempResult);
        }
    }

    public List<IValidator<T>> getValidators() {
        return this.validators;
    }

    public void removeValidator(IValidator<T> validator) {
        this.validators.remove(validator);
    }
}

