/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.StringTools;

public abstract class TlvBasedObject {
    private static final String NEWLINE = "\n";

    public static void toStringValue(StringBuilder sb, int level, Object value) {
        try {
            if (value instanceof byte[]) {
                sb.append(HexTools.bytesToHexString((byte[])value));
            } else if (value instanceof TlvBasedObject) {
                ((TlvBasedObject)value).toString(sb, level);
            } else {
                sb.append(StringTools.safeString(value));
            }
        }
        catch (Exception e) {
            sb.append("<error");
        }
    }

    protected String getTagName() {
        return ClassTools.getUnqualifiedName(this.getClass());
    }

    public final String toString() {
        try {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }
        catch (Exception e) {
            return "<error>";
        }
    }

    public final void toString(StringBuilder sb, int level) {
        this.toStringContent(sb, level);
    }

    protected void toStringClose(StringBuilder sb, int level) {
        this.toStringIndent(sb, level);
        sb.append("}");
    }

    protected void toStringContent(StringBuilder sb, int level) {
        int reset = sb.length();
        int myLevel = level;
        this.toStringOpen(sb, myLevel++);
        int temp = sb.length();
        this.toStringMembers(sb, myLevel);
        if (temp == sb.length()) {
            sb.setLength(reset);
            this.toStringPrimitive(sb, --myLevel);
        } else {
            this.toStringClose(sb, --myLevel);
        }
    }

    protected void toStringIndent(StringBuilder sb, int level) {
        for (int i = 0; i < level; ++i) {
            sb.append("   ");
        }
    }

    protected void toStringMember(StringBuilder sb, int level, String name, Object value, String valueLabel) {
        this.toStringIndent(sb, level);
        sb.append(name);
        sb.append(" = ");
        if (valueLabel != null) {
            sb.append("<");
            sb.append(valueLabel);
            sb.append("> ");
        }
        TlvBasedObject.toStringValue(sb, level, value);
        sb.append(NEWLINE);
    }

    protected void toStringMembers(StringBuilder sb, int level) {
    }

    protected void toStringOpen(StringBuilder sb, int level) {
        sb.append("{");
        sb.append(NEWLINE);
    }

    protected abstract void toStringPrimitive(StringBuilder var1, int var2);
}

