/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.string;

import de.intarsys.tools.exception.InternalError;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.reader.ReaderTools;
import de.intarsys.tools.string.Token;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class StringTools {
    public static final String CR = "\r";
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    public static final String LS = System.getProperty("line.separator");
    public static final String DATEFORMAT_SIMPLE = "yy-MM-dd HH:mm:ss:SSSS";
    private static DateFormat DefaultDateformat;
    public static final String EMPTY = "";
    public static final String DOT = ".";
    public static final String FORMAT_D = "d";
    public static final String FORMAT_F = "f";
    public static final String FORMAT_I = "i";
    public static final String FORMAT_P = "p";
    public static final String FORMAT_T = "t";
    public static final String FORMAT_S = "s";
    private static final String[] NO_ARGS;
    public static final String SPACE = " ";
    public static final Map<Character, String> ESCAPES;

    public static String breakForced(String value, int max, String breakPattern) {
        StringBuilder sb = new StringBuilder();
        if (value != null) {
            int length;
            int begin = 0;
            int end = max;
            int currentlength = length = value.length();
            while (currentlength > max) {
                sb.append(value.substring(begin, end));
                begin += max;
                end += max;
                if ((currentlength -= max) <= 0) continue;
                sb.append(breakPattern);
            }
            if (end > length) {
                end = length;
            }
            sb.append(value.substring(begin, end));
        }
        return sb.toString();
    }

    public static String capitalize(String text) {
        if (StringTools.isEmpty(text)) {
            return EMPTY;
        }
        String first = text.substring(0, 1);
        first = first.toUpperCase();
        if (text.length() > 1) {
            return first + text.substring(1);
        }
        return first;
    }

    public static String decapitalize(String text) {
        if (StringTools.isEmpty(text)) {
            return EMPTY;
        }
        String first = text.substring(0, 1);
        first = first.toLowerCase();
        if (text.length() > 1) {
            return first + text.substring(1);
        }
        return first;
    }

    public static String format(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        if (format.startsWith(FORMAT_S)) {
            return StringTools.formatString(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_F)) {
            return StringTools.formatFloat(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_I)) {
            return StringTools.formatInteger(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_D)) {
            return StringTools.formatDate(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_P)) {
            return StringTools.formatPath(value, format.substring(1));
        }
        if (format.startsWith(FORMAT_T)) {
            return StringTools.formatToken(value);
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(DATEFORMAT_SIMPLE).format(value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value, 32);
        }
        return value.toString();
    }

    protected static String formatDate(Object value, String format) {
        SimpleDateFormat tempFormat;
        Date date = null;
        if (value instanceof Date) {
            date = (Date)value;
        } else if (value instanceof Number) {
            date = new Date(((Number)value).longValue());
        } else {
            if (value instanceof String) {
                return (String)value;
            }
            return EMPTY;
        }
        if (StringTools.isEmpty(format)) {
            return StringTools.formatDateDefault(date);
        }
        String pattern = StringTools.parseArgsString(format);
        if (pattern == null) {
            int dateTime = 43;
            int command = format.charAt(0);
            if (command == 100 || command == 116) {
                dateTime = command;
                command = format.length() > 1 ? (int)format.charAt(1) : 102;
            }
            if (dateTime == 100) {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getDateInstance(3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getDateInstance(2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getDateInstance(0);
                    return dateFormat.format(date);
                }
            } else if (dateTime == 116) {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getTimeInstance(0);
                    return dateFormat.format(date);
                }
            } else {
                if (command == 115) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);
                    return dateFormat.format(date);
                }
                if (command == 109) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
                    return dateFormat.format(date);
                }
                if (command == 102) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance(0, 0);
                    return dateFormat.format(date);
                }
            }
            return StringTools.formatDateDefault(date);
        }
        try {
            tempFormat = new SimpleDateFormat(StringTools.unquote(pattern));
        }
        catch (IOException e) {
            tempFormat = new SimpleDateFormat(pattern);
        }
        return tempFormat.format(date);
    }

    protected static synchronized String formatDateDefault(Date date) {
        if (DefaultDateformat == null) {
            DefaultDateformat = new SimpleDateFormat("yyyy_MM_dd-HH_mm_ss_SSS");
        }
        return DefaultDateformat.format(date);
    }

    protected static String formatFloat(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        double number = 0.0;
        if (value instanceof Number) {
            number = ((Number)value).doubleValue();
        } else if (value instanceof Date) {
            number = ((Date)value).getTime();
        } else if (value instanceof String) {
            try {
                number = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return (String)value;
            }
        } else {
            return value.toString();
        }
        String pattern = StringTools.parseArgsString(format);
        NumberFormat tempFormat = null;
        if (pattern == null) {
            tempFormat = NumberFormat.getNumberInstance();
        } else {
            try {
                tempFormat = new DecimalFormat(StringTools.unquote(pattern));
            }
            catch (IOException e) {
                tempFormat = new DecimalFormat(pattern);
            }
        }
        try {
            return tempFormat.format(number);
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    protected static String formatInteger(Object value, String format) {
        if (value == null) {
            return EMPTY;
        }
        int base = 100;
        if (format.length() > 1) {
            base = format.charAt(1);
        }
        long number = 0L;
        if (value instanceof Number) {
            number = ((Number)value).longValue();
        } else if (value instanceof Date) {
            number = ((Date)value).getTime();
        } else if (value instanceof String) {
            try {
                number = Long.parseLong((String)value);
            }
            catch (NumberFormatException e) {
                return (String)value;
            }
        } else {
            return value.toString();
        }
        try {
            if (base == 98) {
                return Long.toString(number, 2);
            }
            if (base == 111) {
                return Long.toString(number, 8);
            }
            if (base == 100) {
                return Long.toString(number, 10);
            }
            if (base == 120) {
                return Long.toString(number, 16);
            }
            return Long.toString(number, 10);
        }
        catch (Exception e) {
            return value.toString();
        }
    }

    protected static String formatPath(Object value, String format) {
        Object trimmed = FileTools.trimPath(StringTools.safeString(value));
        if (format.length() >= 3) {
            if (format.indexOf("p-/") >= 0 && (((String)trimmed).length() > 1 && ((String)trimmed).startsWith("/") || ((String)trimmed).startsWith("\\"))) {
                trimmed = ((String)trimmed).substring(1);
            }
            if (format.indexOf("p-.") >= 0 && ((String)trimmed).startsWith(DOT)) {
                trimmed = ((String)trimmed).substring(1);
            }
            if (format.indexOf("s-/") >= 0 && (((String)trimmed).length() > 1 && ((String)trimmed).endsWith("/") || ((String)trimmed).endsWith("\\"))) {
                trimmed = ((String)trimmed).substring(0, ((String)trimmed).length() - 1);
            }
            if (format.indexOf("s-.") >= 0 && ((String)trimmed).endsWith(DOT)) {
                trimmed = ((String)trimmed).substring(0, ((String)trimmed).length() - 1);
            }
            if (format.indexOf("p+/") >= 0 && ((String)trimmed).length() > 0 && !((String)trimmed).startsWith("/") && !((String)trimmed).startsWith("\\")) {
                trimmed = "/" + (String)trimmed;
            }
            if (format.indexOf("s+/") >= 0 && ((String)trimmed).length() > 0 && !((String)trimmed).endsWith("/") && !((String)trimmed).endsWith("\\")) {
                trimmed = (String)trimmed + "/";
            }
            if (format.indexOf("p+.") >= 0 && ((String)trimmed).length() > 0 && !((String)trimmed).startsWith(DOT)) {
                trimmed = DOT + (String)trimmed;
            }
            if (format.indexOf("s+.") >= 0 && ((String)trimmed).length() > 0 && !((String)trimmed).endsWith(DOT)) {
                trimmed = (String)trimmed + DOT;
            }
        }
        return trimmed;
    }

    protected static String formatString(Object value, String format) {
        String result = null;
        result = value == null ? EMPTY : value.toString();
        String[] args = StringTools.parseArgs(format);
        if (args.length == 0) {
            return result;
        }
        int rangeStart = 0;
        int rangeStop = result.length() - 1;
        try {
            rangeStart = Integer.parseInt(args[0]);
            if (args.length == 2) {
                rangeStop = Integer.parseInt(args[1]);
            }
        }
        catch (NumberFormatException e) {
            return result;
        }
        if (rangeStart < 0) {
            rangeStart = result.length() + rangeStart;
        }
        if (rangeStop < 0) {
            rangeStop = result.length() + rangeStop;
        }
        if (rangeStart < 0) {
            rangeStart = 0;
        }
        if (rangeStop < 0) {
            rangeStop = 0;
        }
        if (rangeStart > rangeStop) {
            rangeStop = rangeStart - 1;
        }
        if (rangeStart > result.length()) {
            rangeStart = result.length();
        }
        if (rangeStop >= result.length()) {
            rangeStop = result.length() - 1;
        }
        return result.substring(rangeStart, rangeStop + 1);
    }

    protected static String formatToken(Object value) {
        return StringTools.trimAlphaNumeric(StringTools.safeString(value));
    }

    public static String getCommonPrefix(String a, String b, boolean ignoreCase) {
        String tmpB;
        String tmpA;
        int lengthB;
        int lengthA = a.length();
        int max = lengthA > (lengthB = b.length()) ? lengthB : lengthA;
        int i = 0;
        if (ignoreCase) {
            tmpA = a.toLowerCase();
            tmpB = b.toLowerCase();
        } else {
            tmpA = a;
            tmpB = b;
        }
        while (i < max && tmpA.charAt(i) == tmpB.charAt(i)) {
            ++i;
        }
        return a.substring(0, i);
    }

    public static String getFirstLine(String text) {
        int indexLF;
        if (text == null) {
            return EMPTY;
        }
        int indexCR = text.indexOf(CR);
        if (indexCR == -1) {
            indexCR = text.length();
        }
        if ((indexLF = text.indexOf(LF)) == -1) {
            indexLF = text.length();
        }
        return text.substring(0, indexCR > indexLF ? indexLF : indexCR);
    }

    public static String getLeading(String value, int count) {
        if (value == null || value.length() <= count || count <= 3) {
            return value;
        }
        return value.substring(0, count - 3) + "...";
    }

    public static int getLineCount(String text) {
        int count = 1;
        char[] chars = text.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] != '\n') continue;
            ++count;
        }
        return count;
    }

    public static String getOptionValue(String option, String[] args) {
        String lookupArg = "-" + option;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!lookupArg.equals(arg)) continue;
            return args[i + 1];
        }
        return null;
    }

    public static String getTrailing(String value, int count) {
        if (value == null || value.length() <= count) {
            return value;
        }
        return "..." + value.substring(value.length() - count + 3, value.length());
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0 || value.trim().length() == 0;
    }

    public static boolean isNumeric(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char c = value.charAt(0);
        return Character.isDigit(c) || c == '-' || c == '+' || c == '.';
    }

    public static String join(List<String> elements, String separator) {
        if (elements == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        for (String element : elements) {
            if (!buffer.isEmpty() && separator != null) {
                buffer.append(separator);
            }
            buffer.append(element);
        }
        return buffer.toString();
    }

    public static String join(String[] elements, String separator) {
        return StringTools.join(Arrays.asList(elements), separator);
    }

    public static String nullOrString(Object object) {
        return object == null ? null : String.valueOf(object);
    }

    public static String padLeft(String value, int count) {
        if (value == null || value.length() >= count) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = count - value.length(); i > 0; --i) {
            sb.append(SPACE);
        }
        sb.append(value);
        return sb.toString();
    }

    public static String padRight(String value, int count) {
        if (value == null || value.length() >= count) {
            return value;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        for (int i = count - value.length(); i > 0; --i) {
            sb.append(SPACE);
        }
        return sb.toString();
    }

    protected static String[] parseArgs(String string) {
        String tempArgs = StringTools.parseArgsString(string);
        if (tempArgs == null) {
            return NO_ARGS;
        }
        return tempArgs.split(",");
    }

    protected static String parseArgsString(String string) {
        int open = string.indexOf(40);
        int close = string.indexOf(41);
        if (open == -1 || close == -1 || open > close) {
            return null;
        }
        return string.substring(open + 1, close);
    }

    public static String[] parseCommandline(String line) {
        return StringTools.parseCommandline(line, '\\');
    }

    public static String[] parseCommandline(String line, char escape) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        boolean commented = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (commented) {
                if (c != '\n') continue;
                commented = false;
                continue;
            }
            if (escaped) {
                escaped = false;
                if (c != '\"') {
                    sb.append(escape);
                }
                sb.append(c);
                continue;
            }
            if (c == escape) {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                quoted = !quoted;
                continue;
            }
            if (!quoted && c == '#') {
                if (sb.length() > 0) {
                    result.add(sb.toString());
                    sb.setLength(0);
                }
                commented = true;
                continue;
            }
            if (!quoted && Character.isWhitespace(c)) {
                if (sb.length() <= 0) continue;
                result.add(sb.toString());
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (escaped) {
            sb.append(escape);
        }
        if (sb.length() > 0) {
            result.add(sb.toString());
            sb.setLength(0);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String pathAppend(String prefix, String separator, String name) {
        if (StringTools.isEmpty(prefix)) {
            return name;
        }
        return prefix + separator + name;
    }

    public static List<Token> pathParse(String path, char separator) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        try {
            StringReader r = new StringReader(path);
            Token token = ReaderTools.readToken(r, separator);
            while (token != null) {
                tokens.add(token);
                token = ReaderTools.readToken(r, separator);
            }
        }
        catch (IOException e) {
            throw new InternalError("StringReader should not fail");
        }
        return tokens;
    }

    public static String quote(String value) {
        char quote = '\"';
        return StringTools.quote(value, quote);
    }

    public static String quote(String value, char quote) {
        StringBuilder sb = new StringBuilder();
        sb.append(quote);
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == quote) {
                sb.append('\\');
            } else if (c == '\\') {
                sb.append('\\');
            } else if (c == '\r') {
                sb.append('\\');
                c = 'r';
            } else if (c == '\n') {
                sb.append('\\');
                c = 'n';
            } else if (c == '\t') {
                sb.append('\\');
                c = 't';
            }
            sb.append(c);
        }
        sb.append(quote);
        return sb.toString();
    }

    public static String safeString(Object object) {
        try {
            return String.valueOf(object);
        }
        catch (RuntimeException e) {
            return "<unprintable>";
        }
    }

    public static byte[] toByteArray(String value) {
        if (value == null) {
            return null;
        }
        byte[] result = new byte[value.length()];
        value.getBytes(0, result.length, result, 0);
        return result;
    }

    public static String toCamelCase(String value, String allowed) {
        StringTokenizer st = new StringTokenizer(value, allowed, true);
        StringBuilder sb = new StringBuilder();
        while (st.hasMoreTokens()) {
            String[] tokens;
            int length;
            String element = st.nextToken();
            if (allowed.indexOf(element) >= 0) continue;
            String delimiter = EMPTY;
            if (st.hasMoreTokens()) {
                delimiter = st.nextToken();
            }
            if ((length = (tokens = element.split("[^a-zA-Z0-9]")).length) == 1) {
                String token = tokens[0];
                if (token.length() > 0) {
                    if (Character.isLowerCase(token.charAt(0))) {
                        sb.append(token);
                    } else {
                        sb.append(token.toLowerCase());
                    }
                } else {
                    sb.append(token.toLowerCase());
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    String token = tokens[i];
                    if (token.length() <= 0) continue;
                    if (i == 0) {
                        sb.append(Character.toLowerCase(token.charAt(0)));
                    } else {
                        sb.append(Character.toUpperCase(token.charAt(0)));
                    }
                    sb.append(token.substring(1).toLowerCase());
                }
            }
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String toString(byte[] value) {
        if (value == null) {
            return null;
        }
        return new String(value, 0);
    }

    public static String toString(byte[] bytes, Charset charset) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, charset);
    }

    public static String toStringUTF8(byte[] bytes) {
        Charset charset = StandardCharsets.UTF_8;
        return StringTools.toString(bytes, charset);
    }

    public static String trimAlphaNumeric(String value) {
        StringReader reader = new StringReader(value);
        char[] buffer = new char[1];
        StringWriter writer = new StringWriter();
        try {
            while (reader.read(buffer) != -1) {
                if (!Character.isLetterOrDigit(buffer[0])) continue;
                writer.write(buffer);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return writer.toString();
    }

    public static String trimLeft(String value) {
        int i;
        int len = value.length();
        for (i = 0; i < len && Character.isWhitespace(value.charAt(i)); ++i) {
        }
        return value.substring(i);
    }

    public static String trimRight(String value) {
        int i;
        for (i = value.length() - 1; i >= 0 && Character.isWhitespace(value.charAt(i)); --i) {
        }
        return value.substring(0, i + 1);
    }

    public static String trimToNull(String string) {
        if (string == null) {
            return null;
        }
        String returnString = string.trim();
        if (returnString.isEmpty()) {
            return null;
        }
        return returnString;
    }

    public static String unquote(String value) throws IOException {
        if (value == null) {
            return null;
        }
        Token token = ReaderTools.readToken(new StringReader(value), '\u0000');
        return token == null ? EMPTY : token.getValue();
    }

    private StringTools() {
    }

    static {
        NO_ARGS = new String[0];
        HashMap<Character, String> tmp = new HashMap<Character, String>();
        tmp.put(Character.valueOf('\\'), "\\");
        tmp.put(Character.valueOf('\"'), "\"");
        tmp.put(Character.valueOf('\''), "'");
        tmp.put(Character.valueOf('n'), LF);
        tmp.put(Character.valueOf('r'), CR);
        tmp.put(Character.valueOf('t'), "\t");
        tmp.put(Character.valueOf('\n'), null);
        tmp.put(Character.valueOf('\r'), null);
        tmp.put(Character.valueOf('\t'), null);
        tmp.put(Character.valueOf(' '), null);
        ESCAPES = Collections.unmodifiableMap(tmp);
    }
}

