/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize.xml;

import de.intarsys.tools.serialize.SerializationContext;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;

public class XMLSerializationContext
extends SerializationContext {
    private ContentHandler contentHandler;

    public static ContentHandler createContentHandler(OutputStream os, boolean createDocument) throws IOException {
        TransformerFactory factory = TransformerFactory.newInstance();
        if (factory.getFeature("http://javax.xml.transform.sax.SAXTransformerFactory/feature")) {
            TransformerHandler transformerHandler;
            try {
                factory.setAttribute("indent-number", 4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            SAXTransformerFactory saxFactory = (SAXTransformerFactory)factory;
            try {
                transformerHandler = saxFactory.newTransformerHandler();
                if (!createDocument) {
                    transformerHandler.getTransformer().setOutputProperty("omit-xml-declaration", "yes");
                }
                transformerHandler.getTransformer().setOutputProperty("indent", "yes");
                transformerHandler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            }
            catch (TransformerConfigurationException e) {
                IOException ioe = new IOException("unexpected error");
                ioe.initCause(e);
                throw ioe;
            }
            transformerHandler.setResult(new StreamResult(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
            return transformerHandler;
        }
        throw new UnsupportedOperationException("compatibility error");
    }

    public XMLSerializationContext(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public XMLSerializationContext(OutputStream os, boolean createDocument) throws IOException {
        this.contentHandler = XMLSerializationContext.createContentHandler(os, createDocument);
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }
}

