/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.objectmodel;

import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorException;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.objectmodel.IClass;
import de.intarsys.tools.objectmodel.IField;
import de.intarsys.tools.objectmodel.Member;
import de.intarsys.tools.reflect.FieldAccessException;

public class FunctorField
extends Member
implements IField {
    private IFunctor getFunctor;
    private String name;
    private IFunctor setFunctor;

    public FunctorField(String name, IFunctor getFunctor, IFunctor setFunctor) {
        this.name = name;
        this.getFunctor = getFunctor;
        this.setFunctor = setFunctor;
    }

    @Override
    public IClass getFieldType() {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getValue(Object receiver) throws FieldAccessException {
        try {
            FunctorCall call = new FunctorCall(receiver, Args.create());
            return this.getFunctor.perform(call);
        }
        catch (FunctorException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            throw new FieldAccessException(this.getName(), cause);
        }
    }

    @Override
    public Object setValue(Object receiver, Object value) throws FieldAccessException {
        try {
            Args args = Args.createIndexed(value);
            FunctorCall call = new FunctorCall(receiver, args);
            return this.setFunctor.perform(call);
        }
        catch (FunctorException e) {
            throw new FieldAccessException(this.getName(), ExceptionTools.unwrap(e));
        }
    }
}

