/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.lang;

import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SingletonClass
public class Aliases {
    private static final Logger Log = LoggerFactory.getLogger((String)Aliases.class.getName());
    private static final Aliases ACTIVE = new Aliases();
    private static final String PATH = "META-INF/aliases.properties";
    private final Map<String, String> aliases = new HashMap<String, String>();

    public static Aliases get() {
        return ACTIVE;
    }

    public Aliases() {
        try {
            this.init();
        }
        catch (IOException e) {
            Log.warn("aliases error loading", (Throwable)e);
        }
    }

    public void addAlias(String alias, String id) {
        this.aliases.put(alias, id);
    }

    public void clear() {
        this.aliases.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        if (classloader == null) {
            classloader = ClassLoader.getSystemClassLoader();
        }
        Enumeration<URL> urls = classloader.getResources(PATH);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            Log.debug("aliases register from {}", (Object)url);
            InputStream is = null;
            try {
                is = url.openStream();
                this.register(is);
            }
            finally {
                StreamTools.close(is);
            }
        }
    }

    public void register(InputStream is) throws IOException {
        Properties p = new Properties();
        p.load(is);
        p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            Log.debug("aliases register {}={}", key, value);
            this.aliases.put((String)key, (String)value);
        }));
    }

    public String resolve(String name) {
        String result = this.aliases.get(name);
        return result == null ? name : result;
    }
}

