/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.json;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.json.Json;
import de.intarsys.tools.json.JsonArray;
import de.intarsys.tools.json.JsonObjectArgs;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;

public class JsonArrayArgs
implements IArgs {
    private JsonArray json;

    public JsonArrayArgs(JsonArray json) {
        this.json = json;
    }

    @Override
    public IArgs.IBinding add(Object object) {
        this.json.basicAdd(JsonObjectArgs.wrap(object));
        return new Binding(this.json.size() - 1);
    }

    @Override
    public Iterator<IArgs.IBinding> bindings() {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        for (int i = 0; i < this.json.size(); ++i) {
            bindings.add(new Binding(i));
        }
        return bindings.iterator();
    }

    @Override
    public void clear() {
        this.json.clear();
    }

    @Override
    public IArgs copy() {
        return new JsonArrayArgs(Json.copy(this.json));
    }

    @Override
    public IArgs.IBinding declare(String name) {
        throw new IllegalStateException("not supported");
    }

    @Override
    public Object get(int index) {
        return JsonObjectArgs.unwrap(this.json.get(index));
    }

    @Override
    public Object get(int index, Object defaultValue) {
        Object value = this.json.get(index);
        return JsonObjectArgs.unwrap(value);
    }

    @Override
    public Object get(String name) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public Object get(String name, Object defaultValue) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean isDefined(int index) {
        return this.json.size() > index;
    }

    @Override
    public boolean isDefined(String name) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public boolean isNamed() {
        return false;
    }

    @Override
    public Iterator<IArgs.IBinding> iterator() {
        return this.bindings();
    }

    @Override
    public Set<String> names() {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public IArgs.IBinding put(int index, Object value) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public IArgs.IBinding put(String name, Object value) {
        throw new UnsupportedOperationException("not supported");
    }

    @Override
    public int size() {
        return this.json.size();
    }

    @Override
    public void undefine(int index) {
        this.json.remove(index);
    }

    @Override
    public void undefine(String name) {
        throw new UnsupportedOperationException("not supported");
    }

    private class Binding
    implements IArgs.IBinding {
        private int index;

        public Binding(int index) {
            this.index = index;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public Object getValue() {
            return JsonArrayArgs.this.get(this.index);
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public void setValue(Object value) {
            JsonArrayArgs.this.put(this.index, value);
        }
    }
}

