/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.ArgsCryptoBase;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Collections;
import java.util.List;

public class ArgsSigner
extends ArgsCryptoBase {
    protected IArgs createHashArgs(String digestAlgorithm, IArgs args) throws GeneralSecurityException {
        Args hashArgs = Args.create();
        if (!"SHA-256".equals(digestAlgorithm)) {
            hashArgs.put("algorithm", (Object)digestAlgorithm);
        }
        byte[] hashValue = this.hash(digestAlgorithm, args);
        hashArgs.put("raw", (Object)new String(Base64.encode(hashValue)));
        return hashArgs;
    }

    protected String createSignatureValue(String signatureAlgorithm, PrivateKey privateKey, IArgs args) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(signatureAlgorithm);
        signature.initSign(privateKey);
        this.updateSignature(signature, args);
        byte[] signatureValue = signature.sign();
        return new String(Base64.encode(signatureValue));
    }

    protected IArgs createSignedArgs(IArgs args, String signatureAlgorithm, List<String> fields, String digestAlgorithm) throws GeneralSecurityException {
        Args signedArgs = Args.create();
        if (!"SHA256withRSA".equals(signatureAlgorithm)) {
            signedArgs.put("algorithm", (Object)signatureAlgorithm);
        }
        if (fields == null || fields.isEmpty()) {
            fields = DEFAULT_SELECT;
        }
        String selectString = StringTools.join(fields, ";");
        signedArgs.put("select", (Object)selectString);
        IArgs signedContent = this.createSignedContentArgs(args, fields);
        IArgs hash = this.createHashArgs(digestAlgorithm, signedContent);
        signedArgs.put("hash", (Object)hash);
        return signedArgs;
    }

    protected IArgs createSignerArgs(List<Certificate> certificates) throws CertificateEncodingException {
        Args signerArgs = Args.create();
        Args certificatesArgs = Args.create();
        signerArgs.put("certificates", (Object)certificatesArgs);
        for (Certificate certificate : certificates) {
            Args certArgs = Args.create();
            certificatesArgs.add(certArgs);
            if (!"X.509".equals(certificate.getType())) {
                certArgs.put("type", (Object)certificate.getType());
            }
            certArgs.put("value", (Object)new String(Base64.encode(certificate.getEncoded())));
        }
        return signerArgs;
    }

    public IArgs sign(IArgs args, List<String> fields, String digestAlgorithm, String signatureAlgorithm, PrivateKey privateKey, List<Certificate> certificates) throws GeneralSecurityException {
        Args signatureArgs = Args.create();
        signatureArgs.put("type", (Object)"ArgDSig");
        signatureArgs.put("version", (Object)"1.0");
        Args signatureContentArgs = Args.create();
        signatureArgs.put("content", (Object)signatureContentArgs);
        IArgs signedArgs = this.createSignedArgs(args, signatureAlgorithm, fields, digestAlgorithm);
        signatureContentArgs.put("signed", (Object)signedArgs);
        IArgs signerArgs = this.createSignerArgs(certificates);
        signatureContentArgs.put("signer", (Object)signerArgs);
        String signatureValue = this.createSignatureValue(signatureAlgorithm, privateKey, signedArgs);
        signatureContentArgs.put("value", (Object)signatureValue);
        return signatureArgs;
    }

    public IArgs sign(IArgs args, PrivateKey privateKey, List<Certificate> certificates) throws GeneralSecurityException {
        return this.sign(args, Collections.emptyList(), "SHA-256", "SHA256withRSA", privateKey, certificates);
    }
}

