/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IContextSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.IFactorySupport;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsAccess;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.reflect.ObjectTools;
import java.io.IOException;

public class CommonObject
implements IFactorySupport,
IAttributeSupport,
IElementConfigurable,
IArgsAccess,
INotificationSupport,
IContextSupport {
    private IArgs args;
    private Object context;
    private final AttributeMap attributes = new AttributeMap();
    private IElement configuration;
    private final String autoid;
    private IFactory factory;
    private int serial;
    private final EventDispatcher dispatcher = new EventDispatcher(this);

    public CommonObject() {
        this.autoid = ObjectTools.createLabel(this);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    @Override
    public void configure(IElement pElement) throws ConfigurationException {
        this.configuration = pElement;
    }

    public ILocator createLocatorGlobal(String name) throws IOException {
        ILocatorFactory locatorFactory = LocatorTools.createLookupFactory(this.getContext(), this.getFactory(), LocatorFactory.get());
        return locatorFactory.createLocator(name);
    }

    @Override
    public IArgs getArgs() {
        return this.args;
    }

    @Override
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    protected AttributeMap getAttributes() {
        return this.attributes;
    }

    public String getAutoid() {
        return this.autoid;
    }

    protected IElement getConfiguration() {
        return this.configuration;
    }

    public Object getContext() {
        return this.context;
    }

    protected EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public IFactory getFactory() {
        return this.factory;
    }

    public String getLogLabel() {
        return this.autoid;
    }

    public int getSerial() {
        return this.serial;
    }

    public Object myself() {
        return this;
    }

    @Override
    public Object removeAttribute(Object key) {
        Object result = this.attributes.remove(key);
        AttributeChangedEvent event = new AttributeChangedEvent(this, key, result, null);
        this.triggerEvent(event);
        return result;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    @Override
    public void setArgs(IArgs args) {
        if (this.args != null) {
            throw new InvalidRequestException();
        }
        this.args = args;
    }

    @Override
    public Object setAttribute(Object key, Object value) {
        Object result = this.attributes.put(key, value);
        if (result != value) {
            AttributeChangedEvent event = new AttributeChangedEvent(this, key, result, value);
            this.triggerEvent(event);
        }
        return result;
    }

    @Override
    public void setContext(Object context) throws ConfigurationException {
        this.context = context;
    }

    public void setFactory(IFactory factory) {
        if (this.factory != null) {
            throw new InvalidRequestException();
        }
        this.factory = factory;
    }

    public void setSerial(int serial) {
        this.serial = serial;
    }

    public String toString() {
        return this.getLogLabel();
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent(this, attribute, oldValue, newValue);
        this.triggerEvent(event);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }
}

