/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.factory;

import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.component.IActivateDeactivate;
import de.intarsys.tools.component.IStartStop;
import de.intarsys.tools.event.DestroyedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.event.StoppedEvent;
import de.intarsys.tools.factory.CommonDelegatingFactory;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.reflect.ObjectCreationException;

public abstract class AbstractSingletonFactory<T>
extends CommonDelegatingFactory<T> {
    public static final String PREF_ACTIVATE_AT_START = "activateAtStart";
    public static final String PREF_CREATE_AT_START = "createAtStart";
    private final Attribute attrSingleton = new Attribute("singleton");
    private boolean activateAtStart;
    private boolean createAtStart;
    private IFactory<T> delegate;

    protected AbstractSingletonFactory() {
    }

    protected T basicCreateSingleton(IArgs args) throws ObjectCreationException {
        return this.getDelegate().createInstance(args);
    }

    @Override
    protected IFactory<T> basicGetDelegate() {
        return this.delegate;
    }

    protected void clearSingleton(IAttributeSupport singletonContext) {
        if (singletonContext == null) {
            return;
        }
        singletonContext.removeAttribute(this.attrSingleton);
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        IElement elDelegate;
        String delegateId = element.attributeValue("delegate", null);
        if (delegateId != null) {
            this.delegate = Outlet.get().lookupFactory(delegateId);
        }
        if ((elDelegate = element.element("delegate")) != null) {
            try {
                this.delegate = ElementTools.createObject(elDelegate, IFactory.class, this.getContext(), Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException(e);
            }
        }
        super.configure(element);
        this.setCreateAtStart(ElementTools.getBool(element, "createatstart", false));
    }

    @Override
    public T createInstance(IArgs args) throws ObjectCreationException {
        IAttributeSupport singletonContext = this.getSingletonContext(args);
        return this.ensureSingleton(singletonContext);
    }

    protected T createSingleton(IAttributeSupport singletonContext) throws ObjectCreationException {
        if (singletonContext == null) {
            return null;
        }
        T singleton = this.basicCreateSingleton(Args.create());
        if (singleton instanceof INotificationSupport) {
            new SingletonDisposalMonitor(singletonContext, (INotificationSupport)singleton);
        }
        return singleton;
    }

    public T ensureSingleton(IAttributeSupport singletonContext) throws ObjectCreationException {
        T singleton = this.getSingleton(singletonContext);
        if (singleton == null) {
            singleton = this.createSingleton(singletonContext);
            this.setSingleton(singletonContext, singleton);
        }
        return singleton;
    }

    @Override
    public IFactory<T> getDelegate() {
        return this.delegate;
    }

    public T getSingleton(IAttributeSupport singletonContext) {
        if (singletonContext == null) {
            return null;
        }
        return (T)singletonContext.getAttribute(this.attrSingleton);
    }

    protected abstract IAttributeSupport getSingletonContext(IArgs var1);

    public boolean isActivateAtStart() {
        return this.activateAtStart;
    }

    public boolean isCreateAtStart() {
        return this.createAtStart;
    }

    protected void onDisarm(IAttributeSupport context, INotificationSupport singleton) {
        this.clearSingleton(context);
    }

    protected void onSingletonContextStarted(IAttributeSupport singletonContext) {
        Object singleton = null;
        if (this.isCreateAtStart()) {
            try {
                singleton = this.ensureSingleton(singletonContext);
            }
            catch (ObjectCreationException objectCreationException) {
                // empty catch block
            }
        }
        if (singleton instanceof IStartStop) {
            ((IStartStop)singleton).start();
        }
        if (singleton instanceof IActivateDeactivate && this.isActivateAtStart()) {
            ((IActivateDeactivate)singleton).activate();
        }
    }

    protected boolean onSingletonContextStopRequested(IAttributeSupport singletonContext) {
        T singleton = this.getSingleton(singletonContext);
        this.setCreateAtStart(singleton != null);
        this.setActivateAtStart(singleton instanceof IActivateDeactivate && ((IActivateDeactivate)singleton).isActive());
        return true;
    }

    @Override
    protected void preferencesInit(IPreferences preferences) {
        super.preferencesInit(preferences);
        preferences.put(PREF_CREATE_AT_START, this.isCreateAtStart());
        preferences.put(PREF_ACTIVATE_AT_START, false);
    }

    @Override
    protected void preferencesRestore(IPreferences preferences) {
        super.preferencesRestore(preferences);
        this.setCreateAtStart(preferences.getBoolean(PREF_CREATE_AT_START, this.isCreateAtStart()));
        this.setActivateAtStart(preferences.getBoolean(PREF_ACTIVATE_AT_START, this.isActivateAtStart()));
    }

    @Override
    protected void preferencesStore(IPreferences preferences) {
        super.preferencesStore(preferences);
        preferences.put(PREF_CREATE_AT_START, this.isCreateAtStart());
        preferences.put(PREF_ACTIVATE_AT_START, this.isActivateAtStart());
    }

    public void setActivateAtStart(boolean activateAtStart) {
        this.activateAtStart = activateAtStart;
    }

    public void setCreateAtStart(boolean active) {
        this.createAtStart = active;
    }

    public void setDelegate(IFactory<T> delegate) {
        this.delegate = delegate;
    }

    protected void setSingleton(IAttributeSupport singletonContext, T singleton) {
        singletonContext.setAttribute(this.attrSingleton, singleton);
    }

    class SingletonDisposalMonitor
    implements INotificationListener {
        private INotificationSupport singleton;
        private IAttributeSupport context;

        public SingletonDisposalMonitor(IAttributeSupport context, INotificationSupport singleton) {
            this.context = context;
            this.singleton = singleton;
            singleton.addNotificationListener(StoppedEvent.ID, this);
            singleton.addNotificationListener(DestroyedEvent.ID, this);
        }

        public void handleEvent(Event event) {
            if (this.singleton != null) {
                this.singleton.removeNotificationListener(StoppedEvent.ID, this);
                this.singleton.removeNotificationListener(DestroyedEvent.ID, this);
                AbstractSingletonFactory.this.onDisarm(this.context, this.singleton);
            }
        }
    }
}

