/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ConstantResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.functor.Args;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.function.Supplier;

public class TemplateValueSupplier
implements Supplier<String> {
    private String template;
    private boolean urlEncode;

    @Override
    public String get() {
        TaggedStringEvaluator evaluator = TaggedStringEvaluator.decorateLenient(ExpressionEvaluator.get(Mode.UNTRUSTED), new ConstantResolver(null));
        try {
            Object result = evaluator.evaluate(this.getTemplate(), Args.create());
            if (result == null) {
                return null;
            }
            if (result instanceof String) {
                String value = (String)result;
                if (this.isUrlEncode()) {
                    value = URLEncoder.encode(value, "ASCII");
                }
                return value;
            }
            throw new IllegalArgumentException("Expression does not evaluate to a String value");
        }
        catch (EvaluationException e) {
            throw new IllegalArgumentException("Expression evaluation exception", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Error encoding value", e);
        }
    }

    public String getTemplate() {
        return this.template;
    }

    public boolean isUrlEncode() {
        return this.urlEncode;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setUrlEncode(boolean urlEncode) {
        this.urlEncode = urlEncode;
    }
}

