/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;

public class NamespaceMapContext
implements NamespaceContext,
Map<String, String> {
    private final Map<String, String> namespaces;

    public NamespaceMapContext() {
        this.namespaces = new HashMap<String, String>();
    }

    public NamespaceMapContext(Map<String, String> namespaces) {
        if (namespaces == null) {
            throw new IllegalArgumentException("namespaces must not be null");
        }
        this.namespaces = new HashMap<String, String>(namespaces);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.namespaces.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.namespaces.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.namespaces.entrySet();
    }

    @Override
    public String get(Object prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public String getNamespaceURI(String prefix) {
        return this.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            result.add(entry.getKey());
        }
        return result.iterator();
    }

    @Override
    public boolean isEmpty() {
        return this.namespaces.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.namespaces.keySet();
    }

    @Override
    public String put(String prefix, String namespaceURI) {
        return this.namespaces.put(prefix, namespaceURI);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> namespaceMap) {
        this.namespaces.putAll(namespaceMap);
    }

    @Override
    public String remove(Object prefix) {
        return this.namespaces.remove(prefix);
    }

    @Override
    public int size() {
        return this.namespaces.size();
    }

    @Override
    public Collection<String> values() {
        return this.namespaces.values();
    }
}

