/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.crypto;

import de.intarsys.tools.crypto.ISecretStore;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.preferences.PreferencesTools;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.lang.invoke.CallSite;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesSecretStore
implements ISecretStore,
IPreferencesSupport,
IPreferencesSyncher {
    private static final Logger Log = LoggerFactory.getLogger(PreferencesSecretStore.class);
    protected static final String PREFS_SECRET = "secret";
    protected static final String PREFS_ID = "id";
    protected static final String PREFS_SECRETS = "secrets";
    private IPreferences preferences;
    private Map<String, CachedSecret> secrets = new HashMap<String, CachedSecret>();

    protected void basicClearSecret(String id) {
        this.secrets.remove(id);
    }

    protected void basicClearSecrets() {
        this.secrets.clear();
    }

    protected CachedSecret basicGetSecret(String id) {
        return this.secrets.get(id);
    }

    protected void basicSetSecret(String id, Secret secret, boolean persistent) {
        this.secrets.put(id, new CachedSecret(secret, persistent));
    }

    @Override
    public void clearSecret(String id) {
        this.basicClearSecret(id);
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    @Override
    public void clearSecrets() {
        this.basicClearSecrets();
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        return result;
    }

    @Override
    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.common";
    }

    @Override
    public Secret getSecret(String id) {
        CachedSecret cpw = this.basicGetSecret(id);
        if (cpw == null || cpw.getValue() == null) {
            return Secret.EMPTY;
        }
        return cpw.getValue();
    }

    @PostConstruct
    public void install() {
        this.preferencesRestore();
    }

    @Override
    public boolean isPersistent(String id) {
        CachedSecret cpw = this.basicGetSecret(id);
        if (cpw == null) {
            return false;
        }
        return cpw.isPersistent();
    }

    @Override
    public void preferencesRestore() {
        IPreferences preferences = this.getPreferences();
        IPreferences secretsNode = preferences.node(PREFS_SECRETS);
        try {
            IPreferences[] entries = secretsNode.children();
            for (int i = 0; i < entries.length; ++i) {
                IPreferences entry = entries[i];
                String id = entry.get(PREFS_ID);
                Secret secret = PreferencesTools.getSecret(entry, PREFS_SECRET, Secret.EMPTY);
                this.basicSetSecret(id, secret, true);
            }
        }
        catch (Exception e) {
            Log.warn("{} could not read secret from preferences", (Object)this, (Object)e);
        }
    }

    @Override
    public void preferencesStore() {
        IPreferences preferences = this.getPreferences();
        IPreferences secretsNode = preferences.node(PREFS_SECRETS);
        int index = 0;
        HashSet<CallSite> newNodeNames = new HashSet<CallSite>();
        for (Map.Entry<String, CachedSecret> entry : this.secrets.entrySet()) {
            CachedSecret cpw = entry.getValue();
            if (!cpw.isPersistent()) continue;
            String newNodeName = "entry_" + index++;
            newNodeNames.add((CallSite)((Object)newNodeName));
            IPreferences entryNode = secretsNode.node(newNodeName);
            entryNode.put(PREFS_ID, entry.getKey());
            PreferencesTools.putSecret(entryNode, PREFS_SECRET, cpw.getValue());
        }
        try {
            String[] childrenNames = secretsNode.childrenNames();
            for (int i = 0; i < childrenNames.length; ++i) {
                String childName = childrenNames[i];
                if (newNodeNames.contains(childName)) continue;
                secretsNode.node(childName).removeNode();
            }
        }
        catch (BackingStoreException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    @Override
    public void setSecret(String id, Secret secret, boolean persistent) {
        this.basicSetSecret(id, secret, persistent);
        this.preferencesStore();
        try {
            this.getPreferences().flush();
        }
        catch (BackingStoreException e) {
            Log.warn("{} failed to store preferences ", (Object)this, (Object)e);
        }
    }

    @PreDestroy
    public void uninstall() {
        this.preferencesStore();
    }

    static class CachedSecret {
        private Secret value;
        private boolean persistent = false;

        public CachedSecret(Secret secret, boolean persistent) {
            this.value = secret;
            this.persistent = persistent;
        }

        public Secret getValue() {
            return this.value;
        }

        public boolean isPersistent() {
            return this.persistent;
        }
    }
}

