/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.component;

import de.intarsys.tools.component.ComponentInfoCollector;
import de.intarsys.tools.component.IMetaInfoSupport;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentInfo
implements Comparable<ComponentInfo>,
IMetaInfoSupport {
    public static final String IMPLEMENTATION_BUILD = "Implementation-Build";
    public static final String IMPLEMENTATION_TITLE = "Implementation-Title";
    public static final String IMPLEMENTATION_TIMESTAMP = "Implementation-Timestamp";
    public static final String IMPLEMENTATION_VENDOR = "Implementation-Vendor";
    public static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    private static final Logger Log = LoggerFactory.getLogger(ComponentInfo.class);
    private String containerName;
    private String name;
    private String label;
    private String title;
    private String version;
    private String vendor;
    private String build;
    private String timestamp;
    private URL url;
    private final Map<String, ComponentInfo> children = new HashMap<String, ComponentInfo>();

    public void addChild(ComponentInfo ci) {
        this.children.put(ci.getContainerName(), ci);
    }

    public void clearChildren() {
        this.children.clear();
    }

    @Override
    public int compareTo(ComponentInfo o) {
        return this.getName().compareTo(o.getName());
    }

    public void createChildren() {
        this.clearChildren();
        ComponentInfoCollector infoCollector = new ComponentInfoCollector(this);
        infoCollector.addClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            infoCollector.collect();
        }
        catch (IOException e) {
            Log.warn("cannot collect children for {}", (Object)this.getLabel(), (Object)e);
        }
    }

    private String getAttributeValue(Attributes attributes, String attributeName) {
        return attributes.getValue(attributeName);
    }

    public String getBuild() {
        return this.build;
    }

    public Collection<ComponentInfo> getChildren() {
        return this.children.values().stream().sorted().toList();
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    @Override
    public String getMetaInfo(String name) {
        if ("name".equals(name)) {
            return this.getLabel();
        }
        if ("id".equals(name)) {
            return this.getName();
        }
        if ("version".equals(name)) {
            return this.getVersion();
        }
        return null;
    }

    public String getName() {
        if (this.name == null) {
            return this.getTitle();
        }
        return this.name;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getTitle() {
        if (this.title == null) {
            return this.getContainerName();
        }
        return this.title;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public void readFromClass(Class clazz) {
        Package p = clazz.getPackage();
        if (p == null) {
            return;
        }
        this.readFromContainer(ClassTools.getContainerResourceUrl(clazz));
        if (!StringTools.isEmpty(p.getImplementationTitle())) {
            this.setTitle(p.getImplementationTitle());
        }
        if (!StringTools.isEmpty(p.getImplementationVendor())) {
            this.setVendor(p.getImplementationVendor());
        }
        if (!StringTools.isEmpty(p.getImplementationVersion())) {
            this.setVersion(p.getImplementationVersion());
        }
    }

    public void readFromContainer(URL url) {
        if (url.getFile().endsWith(".jar")) {
            this.readFromJar(url);
        } else {
            this.readFromDirectory(url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromDirectory(URL url) {
        InputStream is = null;
        try {
            URL manifestUrl = new URL(url, "META-INF/MANIFEST.MF");
            is = manifestUrl.openStream();
            Manifest manifest = new Manifest(is);
            this.setUrl(url);
            this.setContainerName(PathTools.getName(url.toString()));
            this.readFromManifestAttributes(manifest.getMainAttributes());
        }
        catch (Exception ex) {
            try {
                Log.trace("component info loading manifest from {} failed ({})", (Object)url, (Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                StreamTools.close(is);
                throw throwable;
            }
            StreamTools.close(is);
        }
        StreamTools.close(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readFromJar(URL url) {
        InputStream is = null;
        JarInputStream jis = null;
        try {
            is = url.openStream();
            jis = new JarInputStream(is);
            Manifest manifest = jis.getManifest();
            if (manifest != null) {
                this.readFromManifestAttributes(manifest.getMainAttributes());
            }
            this.setUrl(url);
            this.setContainerName(PathTools.getName(url.toString()));
        }
        catch (Exception ex) {
            try {
                Log.trace("component info loading manifest from {} failed ({})", (Object)url, (Object)ex.getMessage());
            }
            catch (Throwable throwable) {
                StreamTools.close(jis);
                StreamTools.close(is);
                throw throwable;
            }
            StreamTools.close(jis);
            StreamTools.close(is);
        }
        StreamTools.close(jis);
        StreamTools.close(is);
    }

    public void readFromManifestAttributes(Attributes attributes) {
        this.setTitle(this.getAttributeValue(attributes, IMPLEMENTATION_TITLE));
        this.setVersion(this.getAttributeValue(attributes, IMPLEMENTATION_VERSION));
        this.setVendor(this.getAttributeValue(attributes, IMPLEMENTATION_VENDOR));
        this.setBuild(this.getAttributeValue(attributes, IMPLEMENTATION_BUILD));
        this.setTimestamp(this.getAttributeValue(attributes, IMPLEMENTATION_TIMESTAMP));
    }

    public void setBuild(String build) {
        this.build = build;
    }

    public void setContainerName(String name) {
        this.containerName = name;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setName(String displayName) {
        this.name = displayName;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String toStringShort() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        if (!this.getName().equals(this.getContainerName())) {
            sb.append(" (");
            sb.append(this.getContainerName());
            sb.append(")");
        }
        sb.append(", ");
        sb.append(this.getVersion());
        if (!StringTools.isEmpty(this.getBuild())) {
            sb.append(", ");
            sb.append(this.getBuild());
        }
        if (!StringTools.isEmpty(this.getTimestamp())) {
            sb.append(", ");
            sb.append(this.getTimestamp());
        }
        return sb.toString();
    }
}

