/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.activity;

import de.intarsys.tools.activity.IActivity;
import de.intarsys.tools.activity.PACKAGE;
import de.intarsys.tools.activity.Reporter;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.functor.ArgsBuilder;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.progress.BaseProgressMonitor;
import de.intarsys.tools.progress.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportStatus<P extends IActivity<?>>
extends Reporter<Void, P>
implements IProgressMonitor {
    private static final String ARG_SUBTASK = "subTask";
    private static final String ARG_WORK = "work";
    private static final String ARG_WORKED = "worked";
    private static final Logger Log = LoggerFactory.getLogger(ReportStatus.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final BaseProgressMonitor progressMonitor = new BaseProgressMonitor();

    public ReportStatus(P parent) {
        super(parent);
    }

    @Override
    public void begin(String name, float totalWork) {
        this.progressMonitor.begin(name, totalWork);
    }

    @Override
    public void end() {
        this.finish(null);
    }

    @Override
    protected IMessageBundle getDefaultMessageBundle() {
        return Msg;
    }

    public String getFullName() {
        return this.progressMonitor.getFullName();
    }

    @Override
    public IMessage getMessage() {
        IMessage message = super.getMessage();
        String subTaskNameArg = this.getSubTaskName();
        if (subTaskNameArg == null) {
            subTaskNameArg = "";
        }
        IArgs args = new ArgsBuilder().put(ARG_SUBTASK, (Object)subTaskNameArg).put(ARG_WORK, (Object)Float.valueOf(this.getWork())).put(ARG_WORKED, (Object)Float.valueOf(this.getWorked())).getArgs();
        try {
            String value = (String)TemplateEvaluator.get(Mode.UNTRUSTED).evaluate(message.getString(), args);
            return LiteralMessage.create(message.getCode(), value, new Object[0]);
        }
        catch (EvaluationException e) {
            return message;
        }
    }

    public String getSubTaskName() {
        return this.progressMonitor.getSubTaskName();
    }

    public String getTaskName() {
        return this.progressMonitor.getTaskName();
    }

    public float getWork() {
        return this.progressMonitor.getWork();
    }

    public float getWorked() {
        return this.progressMonitor.getWorked();
    }

    public float getWorkedPercent() {
        return this.progressMonitor.getWorkedPercent();
    }

    @Override
    protected void logEnterAfter() {
        Log.debug("{} report '{}'", (Object)this.getLogLabel(), (Object)this.getMessage());
    }

    @Override
    protected void onFinally() {
        this.progressMonitor.end();
        super.onFinally();
    }

    @Override
    public void subTask(String name) {
        this.progressMonitor.subTask(name);
        this.triggerChanged(ARG_SUBTASK, null, name);
    }

    @Override
    public void worked(float amount) {
        this.progressMonitor.worked(amount);
        this.triggerChanged(ARG_WORKED, 0, Float.valueOf(amount));
    }
}

