/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.model.IDocument;
import de.intarsys.processor.document.common.CommonDocumentProcessor;
import de.intarsys.processor.document.standard.ISaver;
import de.intarsys.processor.document.standard.PACKAGE;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.component.ComponentTargetException;
import de.intarsys.tools.event.CancelEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.FailedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.OkEvent;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.MethodException;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DocumentSaver
extends CommonDocumentProcessor
implements ISaver {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ILocator locator;
    private String locatorRecentContext = null;

    protected DocumentSaver(IFactory factory, IDocument doc) {
        super(factory, doc);
    }

    @Override
    protected void basicRun() {
        this.stepSelect();
    }

    @Override
    public ILocator getLocator() {
        return this.locator;
    }

    public String getLocatorRecentContext() {
        return this.locatorRecentContext;
    }

    protected void setLocator(ILocator paramLocator) {
        this.locator = paramLocator;
    }

    public void setLocatorRecentContext(String recentContext) {
        this.locatorRecentContext = recentContext;
    }

    protected void stepDo() {
        try {
            this.getDocument().invoke("save", this.getArgs());
            if (this.getLocator() != null) {
                LocatorUsage.get().addRecentLocator(this.getLocatorRecentContext(), this.getLocator());
            }
            this.ok();
        }
        catch (MethodException e) {
            Throwable cause = ExceptionTools.unwrap((Throwable)e);
            if (cause instanceof FileNotFoundException) {
                String message = Msg.getString("DocumentSaver.ErrorFileNotFound", new Object[]{this.getLocator().getPath()});
                this.fail((Throwable)new ComponentTargetException(message, cause));
            }
            if (cause instanceof IOException) {
                String message = Msg.getString("DocumentSaver.ErrorIO", new Object[]{this.getLocator().getPath(), cause.getLocalizedMessage()});
                this.fail((Throwable)new ComponentTargetException(message, cause));
            }
            String locatorName = this.getLocator() == null ? "" : this.getLocator().getPath();
            String message = Msg.getString("DocumentSaver.ErrorSavingDocument", new Object[]{locatorName, cause.getLocalizedMessage()});
            this.fail((Throwable)new ComponentTargetException(message, cause));
        }
    }

    protected void stepSelect() {
        IProcessor processor;
        try {
            processor = (IProcessor)FactoryTools.createInstance((Object)"de.intarsys.processor.document.standard.SaveSelectorFactory", (IArgs)this.getArgs());
        }
        catch (ObjectCreationException e) {
            this.fail(e);
            return;
        }
        if (processor == null) {
            this.fail(null);
            return;
        }
        processor.addNotificationListener(OkEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentSaver.this.getArgs().put("locator", ((OkEvent)event).getResult());
                DocumentSaver.this.setLocator((ILocator)((OkEvent)event).getResult());
                DocumentSaver.this.stepDo();
            }
        });
        processor.addNotificationListener(CancelEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentSaver.this.cancel();
            }
        });
        processor.addNotificationListener(FailedEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentSaver.this.fail(((FailedEvent)event).getException());
            }
        });
        processor.start();
    }
}

