/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocument;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.document.standard.IFallbackLoader;
import de.intarsys.processor.document.standard.ILoader;
import de.intarsys.processor.document.standard.PACKAGE;
import de.intarsys.processor.model.IProcessor;
import de.intarsys.tools.component.ComponentTargetException;
import de.intarsys.tools.event.CancelEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.FailedEvent;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.OkEvent;
import de.intarsys.tools.exception.EncodedRuntimeException;
import de.intarsys.tools.factory.FactoryTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reporter.Reporter;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DocumentLoader
extends CommonProcessor
implements ILoader {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private IDocument document;
    private ILocator locator;
    private String locatorRecentContext = null;
    private boolean readOnly = false;

    protected DocumentLoader(IFactory factory) {
        super(factory);
    }

    protected Object basicGetResult() {
        return this.getDocument();
    }

    protected void basicLoad(IDocumentType documentType) {
        try {
            IDocument newDocument = documentType.createFromLocator(this.getLocator(), this.getArgs());
            this.setDocument(newDocument);
            if (this.getDocument() != null) {
                if (this.isReadOnly()) {
                    this.getDocument().getLocator().setReadOnly();
                }
                this.getDocument().setAttribute((Object)LocatorUsage.ATTR_LOCATORRECENTCONTEXT, (Object)this.getLocatorRecentContext());
                LocatorUsage.get().addRecentLocator(this.getLocatorRecentContext(), this.getLocator());
            }
            Reporter.get().reportStatus(Msg.getString("DocumentLoader.StatusReady", new Object[]{this.getLocator().getName()}), 0);
            this.ok();
        }
        catch (FileNotFoundException e) {
            String message = Msg.getString("DocumentLoader.ErrorFileNotFound", new Object[]{this.getLocator().getPath()});
            this.fail(new FileNotFoundException(message));
        }
        catch (IOException e) {
            String message = Msg.getString("DocumentLoader.ErrorIO", new Object[]{this.getLocator().getPath(), e.getLocalizedMessage()});
            this.fail(new IOException(message, e));
        }
        catch (Exception e) {
            String message = Msg.getString("DocumentLoader.ErrorIO", new Object[]{this.getLocator().getPath(), e.getLocalizedMessage()});
            this.fail((Throwable)new ComponentTargetException(message, (Throwable)e));
        }
    }

    @Override
    protected void basicRun() throws Exception {
        this.stepSelect();
    }

    protected boolean fallbackLoad(ILocator locator) throws ObjectCreationException {
        IFactory[] fallbackLoaders;
        Args args = Args.create();
        args.put("locator", (Object)locator);
        for (IFactory loaderFactory : fallbackLoaders = Outlet.get().lookupFactories(IFallbackLoader.class)) {
            final ILoader loader = (ILoader)loaderFactory.createInstance((IArgs)args);
            if (loader == null) continue;
            loader.addNotificationListener(CancelEvent.ID, new INotificationListener(){

                public void handleEvent(Event event) {
                    DocumentLoader.this.cancel();
                }
            });
            loader.addNotificationListener(FailedEvent.ID, new INotificationListener(){

                public void handleEvent(Event event) {
                    DocumentLoader.this.fail(((FailedEvent)event).getException());
                }
            });
            loader.addNotificationListener(OkEvent.ID, new INotificationListener(){

                public void handleEvent(Event event) {
                    DocumentLoader.this.setDocument(loader.getDocument());
                    if (DocumentLoader.this.getDocument() != null) {
                        if (DocumentLoader.this.isReadOnly()) {
                            DocumentLoader.this.getDocument().getLocator().setReadOnly();
                        }
                        DocumentLoader.this.getDocument().setAttribute((Object)LocatorUsage.ATTR_LOCATORRECENTCONTEXT, (Object)DocumentLoader.this.getLocatorRecentContext());
                        LocatorUsage.get().addRecentLocator(DocumentLoader.this.getLocatorRecentContext(), DocumentLoader.this.getLocator());
                    }
                    DocumentLoader.this.ok();
                }
            });
            loader.start();
            Reporter.get().reportStatus(Msg.getString("DocumentLoader.StatusReady", new Object[]{this.getLocator().getName()}), 0);
            return true;
        }
        return false;
    }

    @Override
    public IDocument getDocument() {
        return this.document;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getLocatorRecentContext() {
        return this.locatorRecentContext;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setDocument(IDocument document) {
        this.document = document;
    }

    protected void setLocator(ILocator locator) {
        this.locator = locator;
        this.getArgs().put("locator", (Object)this.getLocator());
    }

    public void setLocatorRecentContext(String recentContext) {
        this.locatorRecentContext = recentContext;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stepDo() {
        IProgressMonitor monitor = Reporter.get().reportActivityStart(Msg.getMessage("DocumentLoader.ActivityReading", new Object[]{this.getLocator().getName()}), 0);
        try {
            String extension = LocatorTools.getExtension((ILocator)this.getLocator());
            IDocumentType documentType = DocumentTools.getDocumentTypeForExtension((String)extension);
            if (documentType == null) {
                if (this.fallbackLoad(this.getLocator())) {
                    return;
                }
                documentType = DocumentEnvironment.get().getDefaultDocumentType();
            }
            if (documentType != null) {
                this.basicLoad(documentType);
            } else {
                String message = Msg.getString("DocumentLoader.ErrorUnsupportedType", new Object[]{extension});
                this.fail((Throwable)new EncodedRuntimeException("ProcessFailed", message));
            }
        }
        catch (ObjectCreationException e) {
            this.fail(e);
        }
        finally {
            monitor.end();
        }
    }

    protected void stepSelect() throws ObjectCreationException {
        IProcessor processor = (IProcessor)FactoryTools.createInstance((Object)"de.intarsys.processor.document.standard.LoadSelectorFactory", (IArgs)this.getArgs());
        if (processor == null) {
            this.fail(null);
            return;
        }
        processor.addNotificationListener(OkEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentLoader.this.setLocator((ILocator)((OkEvent)event).getResult());
                DocumentLoader.this.stepDo();
            }
        });
        processor.addNotificationListener(CancelEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentLoader.this.cancel();
            }
        });
        processor.addNotificationListener(FailedEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                DocumentLoader.this.fail(((FailedEvent)event).getException());
            }
        });
        processor.start();
    }
}

