/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.impl;

import de.intarsys.claptz.IExtension;
import de.intarsys.claptz.State;
import de.intarsys.claptz.StateNew;
import de.intarsys.claptz.impl.ExtensionObjectDelete;
import de.intarsys.claptz.impl.ExtensionObjectInsert;
import de.intarsys.claptz.impl.ExtensionObjectUpdate;
import de.intarsys.claptz.impl.ExtensionOperation;
import de.intarsys.claptz.impl.StandardExtensionPoint;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public class StandardExtension
implements IExtension {
    private String extensionPointId;
    private IElement element;
    private final StandardInstrument provider;
    private StandardExtensionPoint extensionPoint;
    private String id;
    private State state = new StateNew("");
    private final AttributeMap attributes = new AttributeMap();
    private String ifdef;
    private String ifnotdef;
    private String absentAction;
    private List<ExtensionOperation> operations = new ArrayList<ExtensionOperation>();

    public StandardExtension(StandardInstrument provider, String extensionPointId, String id) {
        if (extensionPointId == null) {
            throw new NullPointerException("extensionPointId can't be null");
        }
        this.provider = provider;
        this.extensionPointId = extensionPointId;
        this.id = id;
    }

    @Override
    public void attachDelete(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectDelete(target));
        } else if (!tempOperation.isDelete()) {
            if (tempOperation.isInsert()) {
                this.operations.remove(tempOperation);
            } else if (tempOperation.isUpdate()) {
                this.operations.remove(tempOperation);
                this.operations.add(new ExtensionObjectDelete(target));
            }
        }
    }

    @Override
    public void attachInsert(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectInsert(target));
        } else if (tempOperation.isDelete() || tempOperation.isUpdate()) {
            this.operations.remove(tempOperation);
            this.operations.add(new ExtensionObjectInsert(target));
        } else if (tempOperation.isInsert()) {
            // empty if block
        }
    }

    @Override
    public void attachUpdate(Object target) {
        ExtensionOperation tempOperation = this.findOperation(target);
        if (tempOperation == null) {
            this.operations.add(new ExtensionObjectUpdate(target));
        } else if (tempOperation.isDelete()) {
            this.operations.remove(tempOperation);
            this.operations.add(new ExtensionObjectUpdate(target));
        } else if (tempOperation.isInsert() || tempOperation.isUpdate()) {
            // empty if block
        }
    }

    protected ExtensionOperation findOperation(Object target) {
        for (ExtensionOperation extensionOperation : this.getOperations()) {
            if (extensionOperation.getObject() != target) continue;
            return extensionOperation;
        }
        return null;
    }

    public String getAbsentAction() {
        return this.absentAction;
    }

    public final Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    @Override
    public IElement getElement() {
        return this.element;
    }

    @Override
    public StandardExtensionPoint getExtensionPoint() {
        return this.extensionPoint;
    }

    public String getExtensionPointId() {
        return this.extensionPointId;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getIfdef() {
        return this.ifdef;
    }

    public String getIfnotdef() {
        return this.ifnotdef;
    }

    @Override
    public List<ExtensionOperation> getOperations() {
        return this.operations;
    }

    @Override
    public StandardInstrument getProvider() {
        return this.provider;
    }

    public State getState() {
        return this.state;
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.remove(key);
    }

    public void setAbsentAction(String absentAction) {
        this.absentAction = absentAction;
    }

    public final Object setAttribute(Object key, Object value) {
        return this.attributes.put(key, value);
    }

    public void setElement(IElement element) {
        this.element = element;
    }

    protected void setExtensionPoint(StandardExtensionPoint extensionPoint) {
        this.extensionPoint = extensionPoint;
    }

    public void setIfdef(String ifdef) {
        this.ifdef = ifdef;
    }

    public void setIfnotdef(String ifnotdef) {
        this.ifnotdef = ifnotdef;
    }

    public void setState(State state) {
        this.state = state;
    }

    public String toString() {
        try {
            return "IExtension to '" + this.getExtensionPointId() + "' by " + StringTools.safeString((Object)this.getProvider());
        }
        catch (RuntimeException e) {
            return "<unprintable IExtension>";
        }
    }
}

