/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.app;

import de.intarsys.claptz.app.ClaptzApp;
import de.intarsys.tools.cli.CLICommandline;
import de.intarsys.tools.cli.CLICommandlineParser;
import de.intarsys.tools.cli.CLIOptionDescriptor;
import de.intarsys.tools.cli.CLIOptionDescriptorRegistry;
import de.intarsys.tools.cli.ICLICommandline;
import de.intarsys.tools.cli.ICLIOption;
import de.intarsys.tools.cli.ICLIOptionDescriptor;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.ClassLoaderResourceLocator;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.logging.logback.LogbackTools;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.reflect.ObjectTools;
import de.intarsys.tools.reporter.Reporter;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class StandaloneApp
extends ClaptzApp {
    protected static final String CONFIG_BASEDIR = "basedir";
    protected static final String CONFIG_PROFILE = "profile";
    protected static final String CONFIG_PROFILEDIR = "profiledir";
    private static final String DEFAULT_CONFIGFILE = "config/stage.config";
    protected static final int DEFAULT_MAJOR = 7;
    protected static final int DEFAULT_MINOR = 0;
    protected static final int DEFAULT_MICRO = 0;
    private static final Logger Log = LoggerFactory.getLogger(StandaloneApp.class);
    protected static final String PROP_USER_DIR = "user.dir";
    protected static final String PROP_USER_HOME = "user.home";
    public static final int RC_DEFAULT = 0;
    public static final String RESOLVER_REGISTRY = "registry";
    public static final String RESOLVER_ROOTPATHNAMES = "rootPathNames";
    public static final int RC_UNEXPECTEDERROR = -1000;
    public static final String CLIOPT_CONFIG = "config";
    public static final String CLIOPT_DEFINE = "define";
    public static final String CLIOPT_PROFILE = "profile";
    private File baseDir;
    private File dataDir;
    private File profileDir;
    private int rc;
    private File tempDir;
    private File workingDir;
    private String[] commandlineArgs;

    protected StandaloneApp() {
        this.init();
    }

    @Override
    protected void basicStart() throws Exception {
        URL configurationUrl = LogbackTools.getConfigurationURL();
        if (configurationUrl != null) {
            Log.info("{} log already configured from {}", (Object)this, (Object)configurationUrl);
        } else {
            ClassLoaderResourceLocator locator = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), "config/" + LogbackTools.getDefaultConfigurationName());
            LogbackTools.configure((ILocator)locator, new HashMap());
            Log.debug("{} logging configured from {}", this.getLogLabel(), (Object)locator);
        }
        super.basicStart();
    }

    protected File createBaseDir() {
        String dirName = this.getConfiguration() == null ? System.getProperty(PROP_USER_DIR) : this.getConfiguration().attributeValue(CONFIG_BASEDIR, System.getProperty(PROP_USER_DIR));
        File dir = FileTools.resolvePath((File)new File(System.getProperty(PROP_USER_DIR)), (String)dirName);
        if (dir.exists() && dir.isDirectory()) {
            return dir;
        }
        return new File(".");
    }

    protected File createDataDir() {
        return this.getProfileDir();
    }

    @Override
    protected Object createDefaultGlobalConfiguration() throws IOException {
        ClassLoaderResourceLocator result = new ClassLoaderResourceLocator(this.getClass().getClassLoader(), DEFAULT_CONFIGFILE);
        if (!result.exists() && !(result = FileLocatorFactory.BASEDIR.createLocator(DEFAULT_CONFIGFILE)).exists()) {
            result = null;
        }
        return result;
    }

    @Override
    protected Map<String, Object> createDefaultGlobalExpressionEvaluatorVariables(Mode mode) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.putAll(super.createDefaultGlobalExpressionEvaluatorVariables(mode));
        if (mode == Mode.TRUSTED && SystemTools.isWindows()) {
            try {
                variables.put(RESOLVER_REGISTRY, this.createStringEvaluator("de.intarsys.registry.RegistryResolver"));
            }
            catch (ObjectCreationException e) {
                Log.debug("registry resolver not active");
            }
            try {
                variables.put(RESOLVER_ROOTPATHNAMES, this.createStringEvaluator("de.intarsys.os.win.platformsdk.RootPathNamesResolver"));
            }
            catch (ObjectCreationException e) {
                Log.debug("root path names resolver not active");
            }
        }
        return variables;
    }

    @Override
    protected IFileEnvironment createDefaultGlobalFileEnvironment() {
        return new IFileEnvironment(){

            public File getBaseDir() {
                return StandaloneApp.this.getBaseDir();
            }

            public File getDataDir() {
                return StandaloneApp.this.getDataDir();
            }

            public File getProfileDir() {
                return StandaloneApp.this.getProfileDir();
            }

            public File getTempDir() {
                return StandaloneApp.this.getTempDir();
            }

            public File getWorkingDir() {
                return StandaloneApp.this.getWorkingDir();
            }
        };
    }

    protected File createProfileDir() {
        String dirName;
        ICLIOption option = CLICommandline.get().getOption("profile");
        if (option != null) {
            option.setProcessed(true);
            dirName = option.getValue();
        } else {
            dirName = this.getConfiguration().attributeValue("profile", null);
            if (StringTools.isEmpty((String)dirName)) {
                dirName = this.getConfiguration().attributeValue(CONFIG_PROFILEDIR, this.getDefaultProfileDir());
            }
        }
        dirName = TemplateEvaluator.evaluateString((Mode)Mode.TRUSTED, (String)dirName);
        dirName = FileTools.trimPath((String)dirName);
        File dir = new File(dirName);
        if (!dir.isAbsolute()) {
            dir = new File(System.getProperty(PROP_USER_HOME), dirName);
        }
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                dir = new File(System.getProperty(PROP_USER_HOME));
            }
        } else {
            try {
                FileTools.mkdirs((File)dir);
            }
            catch (IOException e) {
                dir = new File(System.getProperty(PROP_USER_HOME));
                Log.warn("failed to create profile dir " + dir.getAbsolutePath(), (Throwable)e);
            }
        }
        return dir;
    }

    protected IStringEvaluator createStringEvaluator(String className) throws ObjectCreationException {
        return (IStringEvaluator)ObjectTools.createObject((String)className, IStringEvaluator.class, (ClassLoader)this.getClass().getClassLoader());
    }

    protected File createTempDir() {
        String path = System.getProperty("java.io.tmpdir");
        return new File(path);
    }

    protected File getBaseDir() {
        if (this.baseDir == null) {
            this.baseDir = this.createBaseDir();
        }
        return this.baseDir;
    }

    public String[] getCommandlineArgs() {
        return this.commandlineArgs;
    }

    protected File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = this.createDataDir();
        }
        return this.dataDir;
    }

    protected String getDefaultProfileDir() {
        if (SystemTools.isWindows()) {
            return "${properties.user.home}/.${app.name:t}_${app.major}.${app.minor}";
        }
        if (SystemTools.isMac()) {
            return "${properties.user.home}/Library/Application Support/${app.name:t}_${app.major}.${app.minor}";
        }
        return "${properties.user.home}/.${app.name:t:.toLowerCase}-${app.major}.${app.minor}";
    }

    protected File getProfileDir() {
        if (this.profileDir == null) {
            this.profileDir = this.createProfileDir();
        }
        return this.profileDir;
    }

    public int getRc() {
        return this.rc;
    }

    protected File getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = this.createTempDir();
        }
        return this.tempDir;
    }

    protected File getWorkingDir() {
        if (this.workingDir == null) {
            this.workingDir = this.getBaseDir();
        }
        return this.workingDir;
    }

    @Override
    protected void hookStartBefore() throws Exception {
        ICLIOption optionConfig;
        this.rc = 0;
        try {
            CLICommandline.set((ICLICommandline)CLICommandline.createCommandLine((String[])this.getCommandlineArgs()));
        }
        catch (RuntimeException e) {
            Log.warn("command line error (" + e.getMessage() + ")");
            CLICommandline.set((ICLICommandline)new CLICommandlineParser().parse(null));
        }
        ICLIOption optDefine = CLICommandline.get().getOption(CLIOPT_DEFINE);
        if (optDefine != null) {
            optDefine.setProcessed(true);
            for (String value : optDefine.getValues()) {
                this.getContainer().ppDefine(value);
            }
        }
        if ((optionConfig = CLICommandline.get().getOption(CLIOPT_CONFIG)) != null) {
            optionConfig.setProcessed(true);
            String filename = optionConfig.getValue();
            this.setGlobalConfiguration(filename);
        }
        super.hookStartBefore();
    }

    @Override
    protected void hookStartFailed(Exception e) {
        super.hookStartFailed(e);
        Reporter.get().reportError("Fatal Error", "start error", (Throwable)e, 0);
        this.rc = -1000;
    }

    private void init() {
        CLIOptionDescriptorRegistry.get().registerDescriptor((ICLIOptionDescriptor)new CLIOptionDescriptor(CLIOPT_DEFINE, null, null));
        CLIOptionDescriptorRegistry.get().registerDescriptor((ICLIOptionDescriptor)new CLIOptionDescriptor(CLIOPT_CONFIG, null, null));
        CLIOptionDescriptorRegistry.get().registerDescriptor((ICLIOptionDescriptor)new CLIOptionDescriptor("profile", null, null));
        CLIOptionDescriptorRegistry.get().registerDescriptor((ICLIOptionDescriptor)new CLIOptionDescriptor("itdirs", null, null));
        CLIOptionDescriptorRegistry.get().registerDescriptor((ICLIOptionDescriptor)new CLIOptionDescriptor("itstrict", null, null));
    }

    public final int launch(String[] pArgs) {
        this.setCommandlineArgs(pArgs);
        this.start();
        return this.rc;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCommandlineArgs(String[] args) {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("{} commandline args: ", this.getLogLabel(), (Object)Arrays.toString(args));
        }
        this.commandlineArgs = args;
    }

    public void setDataDir(File dataDir) {
        this.dataDir = dataDir;
    }

    public void setProfileDir(File profileDir) {
        this.profileDir = profileDir;
    }

    public void setRc(int rc) {
        this.rc = rc;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }
}

