/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.app;

import de.intarsys.claptz.container.ClaptzContainer;
import de.intarsys.tools.application.ApplicationComponent;
import de.intarsys.tools.application.ApplicationComponentTools;
import de.intarsys.tools.application.ApplicationResolver;
import de.intarsys.tools.component.ComponentInternalException;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.crypto.SecretResolver;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.environment.file.IFileEnvironment;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import de.intarsys.tools.expression.ActivityContextAwareResolver;
import de.intarsys.tools.expression.DynamicArgsResolver;
import de.intarsys.tools.expression.EntityResolver;
import de.intarsys.tools.expression.EnvironmentResolver;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MapResolver;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.PropertiesResolver;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.expression.SystemResolver;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.expression.ThreadContextAwareResolver;
import de.intarsys.tools.infoset.Configuration;
import de.intarsys.tools.infoset.DocumentBuilder;
import de.intarsys.tools.infoset.DocumentTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.LocatorTools;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClaptzApp {
    private static final Logger Log = LoggerFactory.getLogger(ClaptzApp.class);
    public static final String RESOLVER_APP = "app";
    public static final String RESOLVER_COUNTERS = "counters";
    public static final String RESOLVER_ENTITY = "entity";
    public static final String RESOLVER_ENVIRONMENT = "environment";
    public static final String RESOLVER_IDENTIFIERS = "identifiers";
    public static final String RESOLVER_NLSMSG = "nlsmsg";
    public static final String RESOLVER_NLSSTR = "nlsstr";
    public static final String RESOLVER_PROPERTIES = "properties";
    public static final String RESOLVER_SECRET = "secret";
    public static final String RESOLVER_SYSTEM = "system";
    public static final String RESOLVER_TIME = "time";
    public static final String ARG_CONFIGURATION = "configuration";
    public static final String ARG_DEFINES = "defines";
    public static final String ARG_FILE_ENVIRONMENT = "fileEnvironment";
    private ClaptzContainer container;
    private Object globalConfiguration;
    private IFileEnvironment globalFileEnvironment;
    protected boolean started;
    private Map<Mode, IStringEvaluator> globalExpressionEvaluators = new EnumMap<Mode, IStringEvaluator>(Mode.class);
    private Map<Mode, IStringEvaluator> globalTemplateEvaluators = new EnumMap<Mode, IStringEvaluator>(Mode.class);
    private IElement configuration;

    protected void basicStart() throws Exception {
    }

    protected void basicStop() {
    }

    public void configure(IElement element) throws ConfigurationException {
        this.configuration = element;
    }

    protected ClaptzContainer createContainer() {
        ClaptzContainer container = new ClaptzContainer();
        return container;
    }

    protected Object createDefaultGlobalConfiguration() throws Exception {
        return null;
    }

    protected IStringEvaluator createDefaultGlobalExpressionEvaluator(Mode mode) {
        ScopedResolver root = new ScopedResolver();
        Map<String, Object> variables = this.createDefaultGlobalExpressionEvaluatorVariables(mode);
        if (!variables.isEmpty()) {
            root.addResolver((IStringEvaluator)MapResolver.createStrict(variables));
        }
        return root.addResolver((IStringEvaluator)new DynamicArgsResolver()).addResolver((IStringEvaluator)new ThreadContextAwareResolver()).addResolver((IStringEvaluator)new ActivityContextAwareResolver());
    }

    protected Map<String, Object> createDefaultGlobalExpressionEvaluatorVariables(Mode mode) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(RESOLVER_APP, new ApplicationResolver());
        variables.put(RESOLVER_ENTITY, new EntityResolver());
        if (mode == Mode.TRUSTED) {
            variables.put(RESOLVER_SYSTEM, new SystemResolver());
            variables.put(RESOLVER_ENVIRONMENT, new EnvironmentResolver());
            variables.put(RESOLVER_PROPERTIES, new PropertiesResolver());
            variables.put(RESOLVER_SECRET, new SecretResolver());
        }
        return variables;
    }

    protected IFileEnvironment createDefaultGlobalFileEnvironment() {
        return new StandardFileEnvironment();
    }

    protected IStringEvaluator createDefaultGlobalTemplateEvaluator(Mode mode) {
        return TaggedStringEvaluator.decorateLenient((IStringEvaluator[])new IStringEvaluator[]{ExpressionEvaluator.get((Mode)mode)});
    }

    public IElement getConfiguration() {
        return this.configuration;
    }

    protected ClaptzContainer getContainer() {
        return this.container;
    }

    public Object getGlobalConfiguration() {
        return this.globalConfiguration;
    }

    public Map<Mode, IStringEvaluator> getGlobalExpressionEvaluators() {
        return new EnumMap<Mode, IStringEvaluator>(this.globalExpressionEvaluators);
    }

    public IFileEnvironment getGlobalFileEnvironment() {
        return this.globalFileEnvironment;
    }

    public Map<Mode, IStringEvaluator> getGlobalTemplateEvaluators() {
        return new EnumMap<Mode, IStringEvaluator>(this.globalTemplateEvaluators);
    }

    protected Object getLogLabel() {
        return "claptz container app";
    }

    protected void hookStartAfter() {
    }

    protected void hookStartBefore() throws Exception {
        this.installGlobalExpressionEvaluators();
        this.installGlobalTemplateEvaluators();
        this.installGlobalFileEnvironment();
        this.installGlobalConfiguration();
        this.installConfiguration();
    }

    protected void hookStartFailed(Exception e) {
    }

    protected void installConfiguration() throws Exception {
        IElement configElement = Configuration.get();
        if (!configElement.getName().equals("stage") && (configElement = configElement.element(this.getClass().getName())) == null) {
            configElement = new DocumentBuilder().getRootElement();
        }
        this.configure(configElement);
        ApplicationComponentTools.configure((ApplicationComponent)ApplicationComponent.get(), (IElement)configElement);
        this.getContainer().configure(configElement);
    }

    protected void installGlobalConfiguration() throws Exception {
        Object configuration = this.getGlobalConfiguration();
        if (configuration == null) {
            configuration = this.createDefaultGlobalConfiguration();
        }
        if (configuration instanceof IElement) {
            Configuration.set((IElement)((IElement)configuration));
        } else {
            ILocator configLocator = LocatorTools.createLocator((Object)configuration, (ILocatorFactory)FileLocatorFactory.BASEDIR, null);
            if (configLocator != null) {
                Log.debug("{} read global configuration from {}", this.getLogLabel(), (Object)configLocator);
                IElement configElement = DocumentTools.parse((ILocator)configLocator).getRootElement();
                Configuration.set((IElement)configElement);
            }
        }
    }

    protected void installGlobalExpressionEvaluators() {
        for (Mode mode : Mode.values()) {
            IStringEvaluator evaluator = this.globalExpressionEvaluators.get(mode);
            if (evaluator == null) {
                evaluator = this.createDefaultGlobalExpressionEvaluator(mode);
            }
            if (evaluator == null) continue;
            ExpressionEvaluator.set((Mode)mode, (IStringEvaluator)evaluator);
        }
    }

    protected void installGlobalFileEnvironment() {
        IFileEnvironment environment = this.getGlobalFileEnvironment();
        if (environment == null) {
            environment = this.createDefaultGlobalFileEnvironment();
        }
        if (environment != null) {
            FileEnvironment.setShared((IFileEnvironment)environment);
        }
    }

    protected void installGlobalTemplateEvaluators() {
        for (Mode mode : Mode.values()) {
            IStringEvaluator evaluator = this.globalTemplateEvaluators.get(mode);
            if (evaluator == null) {
                evaluator = this.createDefaultGlobalTemplateEvaluator(mode);
            }
            if (evaluator == null) continue;
            TemplateEvaluator.set((Mode)mode, (IStringEvaluator)evaluator);
        }
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    public void setConfiguration(IElement configuration) {
        this.configuration = configuration;
    }

    protected void setContainer(ClaptzContainer container) {
        this.container = container;
    }

    public void setGlobalConfiguration(Object globalConfiguration) {
        this.globalConfiguration = globalConfiguration;
    }

    public void setGlobalFileEnvironment(IFileEnvironment globalFileEnvironment) {
        this.globalFileEnvironment = globalFileEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        ClaptzApp claptzApp = this;
        synchronized (claptzApp) {
            if (this.isStarted()) {
                return;
            }
            try {
                Log.debug("{} start()", this.getLogLabel());
                this.setContainer(this.createContainer());
                this.hookStartBefore();
                this.basicStart();
                this.hookStartAfter();
                this.started = true;
                Log.debug("{} started", this.getLogLabel());
            }
            catch (Exception e) {
                this.hookStartFailed(e);
                throw new ComponentInternalException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Log.info("{} stop()", this.getLogLabel());
        ClaptzApp claptzApp = this;
        synchronized (claptzApp) {
            if (!this.isStarted()) {
                return;
            }
            this.basicStop();
            this.started = false;
        }
    }

    public final boolean stopRequested(Set visited) {
        return true;
    }
}

