/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.impl;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateConverter {
    private static final Pattern ISO_8601_PATTERN = Pattern.compile("(?<year>\\d{4})(?:-(?<month>\\d{2})    (?:-(?<day>\\d{2})        (?:T(?<hour>\\d{2}):(?<minute>\\d{2})            (?::(?<second>\\d{2})                (?:\\.(?<fraction>\\d+))?            )?            (?:(?<tzRelation>[Z+-])                (?:(?<tzHours>\\d{2}):(?<tzMinutes>\\d{2}))?            )?        )?    )?)?", 4);
    private static final String ISO_8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final int MILLIS_PER_MINUTE = 60000;
    private static final int MILLIS_PER_HOUR = 3600000;
    private static final SimpleDateFormat[] POTENTIAL_FORMATS = new SimpleDateFormat[]{new SimpleDateFormat("EEEE, dd MMM yyyy hh:mm:ss a"), new SimpleDateFormat("EEEE, MMM dd, yyyy hh:mm:ss a")};
    private static final SimpleDateFormat PDF_DATE_FORMAT = new SimpleDateFormat("'D:'yyyyMMddHHmmss");

    public static synchronized Calendar toCalendar(String date) throws IOException {
        try {
            return DateConverter.fromISO8601(date);
        }
        catch (IOException exception) {
            return DateConverter.fromString(date);
        }
    }

    private static Calendar fromISO8601(String input) throws IOException {
        Matcher matcher = ISO_8601_PATTERN.matcher(input);
        if (!matcher.matches()) {
            throw new IOException(String.format("Error: Invalid date format: %s", input));
        }
        GregorianCalendar calendar = new GregorianCalendar(Locale.ROOT);
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        calendar.set(1, DateConverter.getInteger(matcher, "year", 1));
        calendar.set(2, DateConverter.getInteger(matcher, "month", 1) - 1);
        calendar.set(5, DateConverter.getInteger(matcher, "day", 1));
        calendar.set(11, DateConverter.getInteger(matcher, "hour", 0));
        calendar.set(12, DateConverter.getInteger(matcher, "minute", 0));
        calendar.set(13, DateConverter.getInteger(matcher, "second", 0));
        calendar.set(14, 0);
        String tzRelation = matcher.group("tzRelation");
        if (tzRelation != null) {
            SimpleTimeZone timeZone;
            if ("Z".equals(tzRelation)) {
                timeZone = new SimpleTimeZone(0, "Z");
            } else {
                int offsetHours = DateConverter.getInteger(matcher, "tzHours", 0);
                int offsetMinutes = DateConverter.getInteger(matcher, "tzMinutes", 0);
                int offset = offsetHours * 3600000 + offsetMinutes * 60000;
                if ("-".equals(tzRelation)) {
                    offset = -offset;
                }
                timeZone = new SimpleTimeZone(offset, "");
            }
            calendar.setTimeZone(timeZone);
        }
        return calendar;
    }

    private static int getInteger(Matcher matcher, String group, int defaultValue) {
        String value = matcher.group(group);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    public static String toISO8601(Calendar calendar) {
        SimpleDateFormat format = new SimpleDateFormat(ISO_8601_FORMAT);
        format.setTimeZone(calendar.getTimeZone());
        return format.format(calendar.getTime());
    }

    private static synchronized Calendar fromString(String date) throws IOException {
        GregorianCalendar retval;
        block19: {
            retval = null;
            if ((date = ((String)date).replace("Z", "+00:00")) != null && ((String)date).trim().length() > 0) {
                int year = 0;
                int month = 1;
                int day = 1;
                int hour = 0;
                int minute = 0;
                int second = 0;
                try {
                    SimpleTimeZone zone = null;
                    if (((String)date).startsWith("D:")) {
                        date = ((String)date).substring(2, ((String)date).length());
                    }
                    if (((String)date).length() < 4) {
                        throw new IOException(String.format("Error: Invalid date format: %s", date));
                    }
                    year = Integer.parseInt(((String)date).substring(0, 4));
                    if (((String)date).length() >= 6) {
                        month = Integer.parseInt(((String)date).substring(4, 6));
                    }
                    if (((String)date).length() >= 8) {
                        day = Integer.parseInt(((String)date).substring(6, 8));
                    }
                    if (((String)date).length() >= 10) {
                        hour = Integer.parseInt(((String)date).substring(8, 10));
                    }
                    if (((String)date).length() >= 12) {
                        minute = Integer.parseInt(((String)date).substring(10, 12));
                    }
                    if (((String)date).length() >= 14) {
                        second = Integer.parseInt(((String)date).substring(12, 14));
                    }
                    retval = new GregorianCalendar(year, month - 1, day, hour, minute, second);
                    if (((String)date).length() >= 15) {
                        char sign = ((String)date).charAt(14);
                        if (sign == 'Z') {
                            zone = new SimpleTimeZone(0, "Unknown");
                        } else {
                            int hours = 0;
                            int minutes = 0;
                            if (((String)date).length() >= 17) {
                                hours = sign == '+' ? Integer.parseInt(((String)date).substring(15, 17)) : Integer.parseInt(((String)date).substring(14, 17));
                            }
                            if (((String)date).length() >= 20) {
                                minutes = Integer.parseInt(((String)date).substring(18, 20));
                            }
                            zone = new SimpleTimeZone(hours * 60 * 60 * 1000 + minutes * 60 * 1000, "Unknown");
                        }
                        ((Calendar)retval).setTimeZone(zone);
                    }
                }
                catch (NumberFormatException e) {
                    if (((String)date).substring(((String)date).length() - 3, ((String)date).length() - 2).equals(":") && (((String)date).substring(((String)date).length() - 6, ((String)date).length() - 5).equals("+") || ((String)date).substring(((String)date).length() - 6, ((String)date).length() - 5).equals("-"))) {
                        date = ((String)date).substring(0, ((String)date).length() - 3) + ((String)date).substring(((String)date).length() - 2);
                    }
                    for (int i = 0; retval == null && i < POTENTIAL_FORMATS.length; ++i) {
                        try {
                            Date utilDate = POTENTIAL_FORMATS[i].parse((String)date);
                            retval = new GregorianCalendar();
                            retval.setTime(utilDate);
                            continue;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (retval != null) break block19;
                    throw new IOException(String.format("Error: Invalid date format: %s", date));
                }
            }
        }
        return retval;
    }

    @Deprecated
    public static synchronized String toString(Calendar date) {
        String retval = null;
        if (date != null) {
            StringBuffer buffer = new StringBuffer();
            TimeZone zone = date.getTimeZone();
            long offsetInMinutes = zone.getOffset(date.getTimeInMillis()) / 1000 / 60;
            long hours = Math.abs(offsetInMinutes / 60L);
            long minutes = Math.abs(offsetInMinutes % 60L);
            buffer.append(PDF_DATE_FORMAT.format(date.getTime()));
            if (offsetInMinutes == 0L) {
                buffer.append("Z");
            } else if (offsetInMinutes < 0L) {
                buffer.append("-");
            } else {
                buffer.append("+");
            }
            if (hours < 10L) {
                buffer.append("0");
            }
            buffer.append(hours);
            buffer.append("'");
            if (minutes < 10L) {
                buffer.append("0");
            }
            buffer.append(minutes);
            retval = buffer.toString();
        }
        return retval;
    }

    private DateConverter() {
    }
}

