/*
 * Decompiled with CFR 0.152.
 */
package tec.units.ri.function;

import javax.measure.UnitConverter;
import tec.units.ri.AbstractConverter;
import tec.uom.lib.common.function.ValueSupplier;

public final class AddConverter
extends AbstractConverter
implements ValueSupplier<Double> {
    private double offset;

    public AddConverter(double offset) {
        if (offset == 0.0) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.offset = offset;
    }

    public double getOffset() {
        return this.offset;
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof AddConverter)) {
            return super.concatenate(converter);
        }
        double newOffset = this.offset + ((AddConverter)converter).offset;
        return newOffset == 0.0 ? IDENTITY : new AddConverter(newOffset);
    }

    @Override
    public AddConverter inverse() {
        return new AddConverter(-this.offset);
    }

    @Override
    public double convert(double value) {
        return value + this.offset;
    }

    public final String toString() {
        return "AddConverter(" + this.offset + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof AddConverter)) {
            return false;
        }
        AddConverter that = (AddConverter)obj;
        return this.offset == that.offset;
    }

    @Override
    public int hashCode() {
        long bits = Double.doubleToLongBits(this.offset);
        return (int)(bits ^ bits >>> 32);
    }

    public boolean isLinear() {
        return false;
    }

    public Double getValue() {
        return this.offset;
    }
}

