/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.servlet.filter;

import de.intarsys.tools.nls.NlsContext;
import de.intarsys.tools.string.StringTools;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LanguageFilter
implements Filter {
    private static final Logger Log = LoggerFactory.getLogger(LanguageFilter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String selectedLang = httpRequest.getParameter("lang");
        if (!StringTools.isEmpty((String)selectedLang)) {
            Log.trace("lang={}", (Object)selectedLang);
            Locale newLocale = Locale.forLanguageTag(selectedLang);
            NlsContext.get().pushLocale(newLocale);
            try {
                chain.doFilter(request, (ServletResponse)httpResponse);
            }
            finally {
                NlsContext.get().popLocale();
            }
        } else {
            chain.doFilter(request, (ServletResponse)httpResponse);
        }
    }
}

