/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.x509.attr;

import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Choice;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.asn1.x509.attr.ObjectDigestInfo;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x509.AttCertIssuer;
import org.bouncycastle.asn1.x509.V2Form;

public class AttributeCertificateIssuer
extends ASN1Choice {
    public static final Factory FACTORY = new Factory();
    private GeneralNames issuerName;
    private IssuerSerial baseCertificateId;
    private ObjectDigestInfo objectDigestInfo;
    private int version;

    public IssuerSerial getBaseCertificateId() {
        return this.baseCertificateId;
    }

    public GeneralNames getIssuerName() {
        return this.issuerName;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    public int getVersion() {
        return this.version;
    }

    private void read() {
        AttCertIssuer issuer = AttCertIssuer.getInstance((Object)this.toASN1Primitive());
        if (issuer.getIssuer() instanceof org.bouncycastle.asn1.x509.GeneralNames) {
            this.version = 0;
            this.issuerName = (GeneralNames)GeneralNames.FACTORY.create(issuer.getIssuer());
        } else if (issuer.getIssuer() instanceof V2Form) {
            this.version = 1;
            V2Form v2Issuer = (V2Form)issuer.getIssuer();
            if (v2Issuer.getBaseCertificateID() != null) {
                this.baseCertificateId = (IssuerSerial)IssuerSerial.FACTORY.create((ASN1Encodable)v2Issuer.getBaseCertificateID());
            }
            if (v2Issuer.getIssuerName() != null) {
                this.issuerName = (GeneralNames)GeneralNames.FACTORY.create((ASN1Encodable)v2Issuer.getIssuerName());
            }
            if (v2Issuer.getObjectDigestInfo() != null) {
                this.objectDigestInfo = (ObjectDigestInfo)ObjectDigestInfo.FACTORY.create((ASN1Encodable)v2Issuer.getObjectDigestInfo());
            }
        }
    }

    @Override
    protected void setValueHolder(ASN1ValueHolder vh) {
        super.setValueHolder(vh);
        this.read();
    }

    public static class Factory
    extends ASN1Choice.Factory<AttributeCertificateIssuer> {
    }
}

