/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.asn1.x509.attr.AttributeCertificate;
import de.intarsys.asn1.x509.attr.Attributes;
import java.util.ArrayList;
import java.util.List;

public class SignerAttribute
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void addCertifiedAttributes(AttributeCertificate certifiedAttributes) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 1, certifiedAttributes);
        this.getValueHolder().addChild(tagged);
    }

    public void addClaimedAttributes(Attributes claimedAttributes) {
        ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, claimedAttributes);
        this.getValueHolder().addChild(tagged);
    }

    protected List<ASN1ValueHolder> getAllTaggedUntag(int tag, boolean explicit) {
        ArrayList<ASN1ValueHolder> result = new ArrayList<ASN1ValueHolder>();
        for (int i = 0; i < this.getValueHolder().size(); ++i) {
            ASN1TaggedHolder vh = (ASN1TaggedHolder)this.getValueHolder().getChild(i);
            vh.setExplicit(true);
            if (vh.getTagNo() != tag) continue;
            result.add(vh.getChild());
        }
        return result;
    }

    public List<AttributeCertificate> getCertifiedAttributes() {
        ArrayList<AttributeCertificate> result = new ArrayList<AttributeCertificate>();
        for (ASN1ValueHolder vh : this.getAllTaggedUntag(1, true)) {
            result.add((AttributeCertificate)AttributeCertificate.FACTORY.create(vh));
        }
        return result;
    }

    public List<Attributes> getClaimedAttributes() {
        ArrayList<Attributes> result = new ArrayList<Attributes>();
        for (ASN1ValueHolder vh : this.getAllTaggedUntag(0, true)) {
            result.add((Attributes)Attributes.FACTORY.create(vh));
        }
        return result;
    }

    public static class Factory
    extends ASN1Based.Factory<SignerAttribute> {
    }
}

