/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms.attr;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1SequenceHolder;
import de.intarsys.asn1.model.ASN1TaggedHolder;
import de.intarsys.asn1.model.ASN1ValueHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.x509.CertificateList;

public class RevocationValues
extends ASN1Based {
    public static final Factory FACTORY = new Factory();

    public void addCRL(ASN1Encodable asn1CRL) {
        ASN1ValueHolder crlVals = this.getCrlVals();
        if (crlVals == null) {
            crlVals = new ASN1SequenceHolder();
            ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 0, crlVals);
            this.getValueHolder().insertChild(0, tagged);
        }
        crlVals.addChild(asn1CRL);
    }

    public void addOCSP(ASN1Encodable asn1BasicOCSPResponse) {
        ASN1ValueHolder ocspVals = this.getOCSPVals();
        if (ocspVals == null) {
            ocspVals = new ASN1SequenceHolder();
            ASN1TaggedHolder tagged = new ASN1TaggedHolder(true, 1, ocspVals);
            if (this.getValueHolder().size() == 0) {
                this.getValueHolder().setChild(0, tagged);
            } else {
                this.getValueHolder().setChild(1, tagged);
            }
        }
        ocspVals.addChild(asn1BasicOCSPResponse);
    }

    public RevocationValues copy() throws IOException {
        return (RevocationValues)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    public CertificateList getCRL(int index) {
        ASN1ValueHolder crls = this.getCrlVals();
        if (crls == null) {
            return null;
        }
        ASN1ValueHolder obj = crls.getChild(index);
        return CertificateList.getInstance((Object)obj);
    }

    public int getCRLCount() {
        ASN1ValueHolder crls = this.getCrlVals();
        if (crls == null) {
            return 0;
        }
        return crls.size();
    }

    public List getCRLs() {
        if (this.getCRLCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<CertificateList> result = new ArrayList<CertificateList>(this.getCRLCount());
        for (int i = 0; i < this.getCRLCount(); ++i) {
            CertificateList crl = this.getCRL(i);
            result.add(crl);
        }
        return result;
    }

    protected ASN1ValueHolder getCrlVals() {
        return this.getValueHolder().getNextTaggedGetChild(0, 0, true);
    }

    public BasicOCSPResponse getOCSP(int index) {
        ASN1ValueHolder ocsps = this.getOCSPVals();
        if (ocsps == null) {
            return null;
        }
        ASN1ValueHolder obj = ocsps.getChild(index);
        return BasicOCSPResponse.getInstance((Object)obj);
    }

    public int getOCSPCount() {
        ASN1ValueHolder ocsps = this.getOCSPVals();
        if (ocsps == null) {
            return 0;
        }
        return ocsps.size();
    }

    public List getOCSPs() {
        if (this.getOCSPCount() == 0) {
            return Collections.emptyList();
        }
        ArrayList<BasicOCSPResponse> result = new ArrayList<BasicOCSPResponse>(this.getOCSPCount());
        for (int i = 0; i < this.getOCSPCount(); ++i) {
            BasicOCSPResponse ocsp = this.getOCSP(i);
            result.add(ocsp);
        }
        return result;
    }

    protected ASN1ValueHolder getOCSPVals() {
        return this.getValueHolder().getNextTaggedGetChild(0, 1, true);
    }

    protected ASN1ValueHolder getOtherRevVals() {
        return this.getValueHolder().getNextTaggedGetChild(0, 2, true);
    }

    public static class Factory
    extends ASN1Based.Factory<RevocationValues> {
    }
}

