/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.asn1.cms;

import de.intarsys.asn1.cms.CMSContent;
import de.intarsys.asn1.cms.ContentInfo;
import de.intarsys.asn1.cms.ContentType;
import de.intarsys.asn1.cms.Data;
import de.intarsys.asn1.cms.DigestedData;
import de.intarsys.asn1.cms.EncryptedData;
import de.intarsys.asn1.cms.EnvelopedData;
import de.intarsys.asn1.cms.PACKAGE;
import de.intarsys.asn1.cms.SignedAndEnvelopedData;
import de.intarsys.asn1.cms.SignedData;
import de.intarsys.asn1.cms.UnknownContent;
import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.model.ASN1ValueHolder;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.PrettyPrinter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;

public class CMS
extends ContentInfo {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    public static final Factory<CMS> FACTORY = new Factory();

    public static CMS createFromInputStream(InputStream inputStream) throws IOException {
        try {
            return ASN1BasedTools.create(FACTORY, inputStream);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(Msg.getString("CMS.errorUnknownObject", new Object[0]));
        }
    }

    public static CMS createFromLocator(ILocator locator) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = locator.getInputStream();
            CMS cms = CMS.createFromInputStream(inputStream);
            if (cms == null) {
                throw new IOException(Msg.getString("CMS.errorUnknownObject", new Object[0]));
            }
            CMS cMS = cms;
            return cMS;
        }
        catch (IllegalArgumentException e) {
            throw new IOException(Msg.getString("CMS.errorUnknownObject", new Object[0]));
        }
        finally {
            StreamTools.close((Closeable)inputStream);
        }
    }

    public CMS copy() throws IOException {
        return (CMS)FACTORY.create((ASN1Encodable)this.basicCopy());
    }

    protected void ensureContentType(ASN1ObjectIdentifier id) {
        if (this.getContentType() == null) {
            this.setContentType((ContentType)ContentType.FACTORY.create((ASN1Encodable)id));
        } else if (!this.getContentType().equalsId(id)) {
            this.getContentType().setIdentifier(id.getId());
        }
    }

    public CMSContent getContentObject() {
        if (this.isData()) {
            return this.getData();
        }
        if (this.isDigestedData()) {
            return this.getDigestedData();
        }
        if (this.isEncryptedData()) {
            return this.getEncryptedData();
        }
        if (this.isEnvelopedData()) {
            return this.getEnvelopedData();
        }
        if (this.isSignedAndEnvelopedData()) {
            return this.getSignedAndEnvelopedData();
        }
        if (this.isSignedData()) {
            return this.getSignedData();
        }
        return this.getUnknownContent();
    }

    protected <U extends CMSContent> U getContentObject(ASN1Based.Factory<U> factory) {
        if (this.getValueHolder().size() < 2) {
            return null;
        }
        ASN1ValueHolder temp = this.getValueHolder().getChild(1);
        temp.setExplicit(true);
        return (U)((CMSContent)factory.create(temp.getChild()));
    }

    public Data getData() {
        if (this.isData()) {
            return this.getContentObject(Data.FACTORY);
        }
        return null;
    }

    public DigestedData getDigestedData() {
        if (this.isDigestedData()) {
            return this.getContentObject(DigestedData.FACTORY);
        }
        return null;
    }

    public EncryptedData getEncryptedData() {
        if (this.isEncryptedData()) {
            return this.getContentObject(EncryptedData.FACTORY);
        }
        return null;
    }

    public EnvelopedData getEnvelopedData() {
        if (this.isEnvelopedData()) {
            return this.getContentObject(EnvelopedData.FACTORY);
        }
        return null;
    }

    public SignedAndEnvelopedData getSignedAndEnvelopedData() {
        if (this.isSignedAndEnvelopedData()) {
            return this.getContentObject(SignedAndEnvelopedData.FACTORY);
        }
        return null;
    }

    public SignedData getSignedData() {
        if (this.isSignedData()) {
            return this.getContentObject(SignedData.FACTORY);
        }
        return null;
    }

    public UnknownContent getUnknownContent() {
        return this.getContentObject(UnknownContent.FACTORY);
    }

    public boolean isContentTypeId(ASN1ObjectIdentifier oid) {
        ContentType ct = this.getContentType();
        if (ct == null) {
            return false;
        }
        return ct.equalsId(oid);
    }

    public boolean isData() {
        return this.isContentTypeId(CMSObjectIdentifiers.data);
    }

    public boolean isDigestedData() {
        return this.isContentTypeId(CMSObjectIdentifiers.digestedData);
    }

    public boolean isEncryptedData() {
        return this.isContentTypeId(CMSObjectIdentifiers.encryptedData);
    }

    public boolean isEnvelopedData() {
        return this.isContentTypeId(CMSObjectIdentifiers.envelopedData);
    }

    public boolean isSignedAndEnvelopedData() {
        return this.isContentTypeId(CMSObjectIdentifiers.signedAndEnvelopedData);
    }

    public boolean isSignedData() {
        return this.isContentTypeId(CMSObjectIdentifiers.signedData);
    }

    public void setData(Data data) {
        this.ensureContentType(CMSObjectIdentifiers.data);
        this.setContent(data);
    }

    public void setDigestedData(DigestedData digestedData) {
        this.ensureContentType(CMSObjectIdentifiers.digestedData);
        this.setContent(digestedData);
    }

    public void setEncryptedData(EncryptedData encryptedData) {
        this.ensureContentType(CMSObjectIdentifiers.encryptedData);
        this.setContent(encryptedData);
    }

    public void setEnvelopedData(EnvelopedData envelopedData) {
        this.ensureContentType(CMSObjectIdentifiers.envelopedData);
        this.setContent(envelopedData);
    }

    public void setSignedAndEnvelopedData(SignedAndEnvelopedData signedAndEnvelopedData) {
        this.ensureContentType(CMSObjectIdentifiers.signedAndEnvelopedData);
        this.setContent(signedAndEnvelopedData);
    }

    public void setSignedData(SignedData signedData) {
        this.ensureContentType(CMSObjectIdentifiers.signedData);
        this.setContent(signedData);
    }

    @Override
    public void toString(PrettyPrinter printer) {
        printer.appendMember("contentType", (Object)this.getValueHolder().getChild(0), null);
        String contentTypeId = this.getContentTypeId();
        CMSContent.Factory factory = CMSContent.findFactory(contentTypeId);
        if (this.getValueHolder().size() > 1) {
            ASN1ValueHolder vhContent = this.getValueHolder().getChild(1);
            Object content = factory.create(vhContent.getChild());
            printer.appendMember("content", content, null);
        }
    }

    public static class Factory<T extends CMS>
    extends ContentInfo.Factory<T> {
        @Override
        protected T basicCreate(ASN1Encodable asn1) throws ObjectCreationException {
            if (!ASN1Tools.isASN1Sequence(asn1)) {
                throw new IllegalArgumentException();
            }
            return (T)((CMS)super.basicCreate(asn1));
        }
    }
}

