/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.license;

import de.intarsys.tools.license.License;
import de.intarsys.tools.license.LicenseProperty;
import de.intarsys.tools.license.LicenseRepository;
import de.intarsys.tools.serialize.SerializationContext;
import de.intarsys.tools.serialize.xml.XMLSerializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LicenseContainerSerializer
extends XMLSerializer {
    public LicenseContainerSerializer(SerializationContext context) {
        super(context);
    }

    public LicenseContainerSerializer(SerializationContext context, boolean createDocument) {
        super(context, createDocument);
    }

    protected void serialize(Object object, ContentHandler handler) throws SAXException, IOException {
        LicenseRepository repository = (LicenseRepository)object;
        this.serializeRepository(repository, handler);
    }

    protected void serializeLicense(License license, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"type", (String)license.getType());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"validfrom", (String)license.getValidFromString());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"validto", (String)license.getValidToString());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"productid", (String)license.getProductId());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"productversion", (String)license.getProductVersionString());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"owner", (String)license.getOwnerKey());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"quantity", (String)license.getQuantityString());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"key", (String)license.getKeyString());
        this.doStartElement(handler, "license", attrs);
        Iterator<LicenseProperty> it = license.getProperties();
        while (it.hasNext()) {
            LicenseProperty property = it.next();
            if (!property.isGeneric()) continue;
            this.doCharacters(handler, "\n");
            this.serializeProperty(property, handler);
        }
        this.doEndElement(handler, "license");
        this.doCharacters(handler, "\n");
    }

    protected void serializeProperty(LicenseProperty property, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attrs = new AttributesImpl();
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"name", (String)property.getName());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"value", (String)property.getValueUnitString());
        LicenseContainerSerializer.addAttribute((AttributesImpl)attrs, (String)"options", (String)property.getOptionsString());
        this.doStartElement(handler, "property", attrs);
        this.doEndElement(handler, "property");
    }

    protected void serializeRepository(LicenseRepository repository, ContentHandler handler) throws SAXException, IOException {
        AttributesImpl attributes = new AttributesImpl();
        this.doStartElement(handler, "licenses", attributes);
        List<License> licenses = repository.getLicenses();
        for (License license : licenses) {
            this.serializeLicense(license, handler);
        }
        this.doEndElement(handler, "licenses");
    }
}

