/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.FieldCalculationRule;
import de.intarsys.pdf.design.widget.format.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SimpleCalculationRule
extends FieldCalculationRule {
    public static final String TYPE = "simple";
    public static final String OPERATOR_SUM = "SUM";
    public static final String OPERATOR_PRD = "PRD";
    public static final String OPERATOR_AVG = "AVG";
    public static final String OPERATOR_MIN = "MIN";
    public static final String OPERATOR_MAX = "MAX";
    public static final String[] OPERATORS = new String[]{"SUM", "PRD", "AVG", "MIN", "MAX"};
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String operator = "SUM";
    private List fields = new ArrayList();

    public void addField(String name) {
        this.fields.add(name);
    }

    @Override
    protected void generateScripts() {
        StringBuilder script = new StringBuilder();
        script.append("AFSimple_Calculate");
        script.append("('").append(this.getOperator()).append("', new Array(");
        Iterator i = this.getFields().iterator();
        while (i.hasNext()) {
            String field = (String)i.next();
            script.append("'").append(field).append("'");
            if (!i.hasNext()) continue;
            script.append(",");
        }
        script.append("));");
        this.setCalculationScript(script.toString());
    }

    public List getFields() {
        return this.fields;
    }

    public String getOperator() {
        return this.operator;
    }

    public String getOperatorLabel(String operator) {
        return Msg.getString("SimpleCalculationRule.OperatorLabel." + operator, new Object[0]);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void removeField(String name) {
        this.fields.remove(name);
    }

    public void setFields(List fields) {
        this.fields = fields;
    }

    public void setOperator(String operation) {
        this.operator = operation;
    }
}

