/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.app.design;

import de.intarsys.pdf.app.design.IAnnotationDesigner;
import de.intarsys.pdf.app.design.IAnnotationDesignerRegistry;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.tools.provider.ProviderTools;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class StandardAnnotationDesignerRegistry
implements IAnnotationDesignerRegistry {
    private Map<COSName, IAnnotationDesigner> instances = new HashMap<COSName, IAnnotationDesigner>();
    private boolean initialized = false;
    private boolean lookupProviders = true;

    protected IAnnotationDesigner[] findProviders() {
        ArrayList<IAnnotationDesigner> result = new ArrayList<IAnnotationDesigner>();
        Iterator ps = ProviderTools.providers(IAnnotationDesigner.class);
        while (ps.hasNext()) {
            result.add((IAnnotationDesigner)ps.next());
        }
        return result.toArray(new IAnnotationDesigner[result.size()]);
    }

    @Override
    public synchronized IAnnotationDesigner[] getAnnotationDesigners() {
        this.init();
        return this.instances.values().toArray(new IAnnotationDesigner[this.instances.size()]);
    }

    protected void init() {
        if (!this.lookupProviders || this.initialized) {
            return;
        }
        this.initialized = true;
        IAnnotationDesigner[] providers = this.findProviders();
        for (int i = 0; i < providers.length; ++i) {
            IAnnotationDesigner provider = providers[i];
            this.registerAnnotationDesigner(provider);
        }
    }

    public boolean isLookupProviders() {
        return this.lookupProviders;
    }

    @Override
    public synchronized IAnnotationDesigner lookupAnnotationDesigner(COSName type) {
        this.init();
        return this.instances.get(type);
    }

    @Override
    public synchronized void registerAnnotationDesigner(IAnnotationDesigner annotationDesigner) {
        this.instances.put(annotationDesigner.getAnnotationType(), annotationDesigner);
    }

    public void setLookupProviders(boolean lookupProviders) {
        this.lookupProviders = lookupProviders;
    }

    @Override
    public synchronized void unregisterAnnotationDesigner(IAnnotationDesigner annotationDesigner) {
        this.instances.remove(annotationDesigner.getAnnotationType());
    }
}

