/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.http.common.HttpConstants;
import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.content.IHttpEntityDecoder;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.provider.ProviderTools;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.io.FileCleaningTracker;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpEntityDecoder
implements IHttpEntityDecoder {
    protected static FileCleaningTracker Tracker = new FileCleaningTracker();
    private static final Map<String, IHttpEntityDecoder> Registry = new HashMap<String, IHttpEntityDecoder>();
    private static final Logger Log = LoggerFactory.getLogger(HttpEntityDecoder.class);

    public static IHttpEntityDecoder lookupDecoder(String type) {
        return Registry.get(type);
    }

    public static void registerDecoder(IHttpEntityDecoder decoder) {
        Log.debug("registering decoder for '" + decoder.getContentType() + "'");
        Registry.put(decoder.getContentType(), decoder);
    }

    protected abstract Object basicDecode(Header[] var1, HttpEntity var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object basicDecodeToLocator(HttpEntity entity, String filename) throws IOException {
        FileLocator locator;
        String charset = HttpTools.getHeaderElementParam((Header)entity.getContentType(), (String)"charset", (String)HttpConstants.CHARSET_DEFAULT);
        File tempFile = FileTools.createTempFile((String)filename);
        DeferredFileOutputStream os = null;
        InputStream is = null;
        try {
            is = entity.getContent();
            os = new DeferredFileOutputStream(10000, tempFile);
            StreamTools.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            StreamTools.close((Closeable)is);
            StreamTools.close(os);
            throw throwable;
        }
        StreamTools.close((Closeable)is);
        StreamTools.close((Closeable)os);
        if (os.isInMemory()) {
            byte[] data = os.getData();
            locator = new ByteArrayLocator(data, tempFile.getName());
            ((ByteArrayLocator)locator).setCharset(charset);
        } else {
            locator = new FileLocator(tempFile);
            locator.setCharset(charset);
        }
        Tracker.track(tempFile, (Object)locator);
        return locator;
    }

    @Override
    public final Object decode(Header[] headers, HttpEntity entity) throws IOException {
        Object decoded = this.basicDecode(headers, entity);
        if (decoded instanceof Map) {
            Map map = (Map)decoded;
            Object wrapped = map.get("_wrapped");
            if (map.size() == 1 && wrapped != null) {
                return wrapped;
            }
        }
        return decoded;
    }

    static {
        Iterator ps = ProviderTools.providers(IHttpEntityDecoder.class);
        while (ps.hasNext()) {
            HttpEntityDecoder.registerDecoder((IHttpEntityDecoder)ps.next());
        }
    }
}

