/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jmx;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.jmx.CommonNotificationListener;
import de.intarsys.tools.jmx.CommonNotificationListenerFactory;
import de.intarsys.tools.reporter.Reporter;
import javax.management.Notification;

public class ReporterNotificationListener
extends CommonNotificationListener {
    private String title = "Benachrichtigung";
    private String message = "${notification.type}: ${notification.message}";
    private int style = 0;

    public ReporterNotificationListener() {
    }

    public ReporterNotificationListener(CommonNotificationListenerFactory factory) {
        super(factory);
    }

    @Override
    protected void basicHandleNotification(Notification notification) {
        String tempTitle = this.expand(this.getTitle(), notification);
        String tempMessage = this.expand(this.getMessage(), notification);
        Reporter.get().reportMessage(tempTitle, tempMessage, this.getStyle());
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setTitle(element.attributeValue("title", this.getTitle()));
        this.setMessage(element.attributeValue("message", this.getMessage()));
    }

    public String getMessage() {
        return this.message;
    }

    public int getStyle() {
        return this.style;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue("title", this.getTitle());
        element.setAttributeValue("message", this.getMessage());
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        return "Benachrichtigung an der Oberfl\u00e4che";
    }
}

